/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.UserUtil;

public class SpaceTaskDataInitializer
extends SpaceListenerPlugin {
    private static final Log log = ExoLogger.getExoLogger(SpaceTaskDataInitializer.class);
    private ProjectService projectService;
    private StatusService statusServ;

    public SpaceTaskDataInitializer(ProjectService pServ, StatusService statusServ) {
        this.projectService = pServ;
        this.statusServ = statusServ;
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String space_group_id = space.getGroupId();
        List<String> memberships = UserUtil.getSpaceMemberships(space_group_id);
        HashSet<String> managers = new HashSet<String>(Arrays.asList(memberships.get(0)));
        HashSet<String> participators = new HashSet<String>(Arrays.asList(memberships.get(1)));
        ProjectDto project = ProjectUtil.newProjectInstanceDto(space.getDisplayName(), "", managers, participators);
        project = this.projectService.createProject(project);
        this.statusServ.createInitialStatuses(project);
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }
}

