/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.exception.UnAuthorizedOperationException;
import org.exoplatform.task.management.controller.AbstractController;
import org.exoplatform.task.management.model.Paging;
import org.exoplatform.task.management.model.ViewState;
import org.exoplatform.task.management.model.ViewType;
import org.exoplatform.task.management.service.ViewStateService;
import org.exoplatform.task.management.templates.comments;
import org.exoplatform.task.management.templates.confirmDeleteTask;
import org.exoplatform.task.management.templates.detail;
import org.exoplatform.task.management.templates.projectTaskListView;
import org.exoplatform.task.management.templates.taskComments;
import org.exoplatform.task.management.templates.taskLogs;
import org.exoplatform.task.management.util.JsonUtil;
import org.exoplatform.task.model.CommentModel;
import org.exoplatform.task.model.GroupKey;
import org.exoplatform.task.model.TaskModel;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.ParserContext;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskParser;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.CommentUtil;
import org.exoplatform.task.util.DateUtil;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.TaskUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskController
extends AbstractController {
    @Inject
    TaskService taskService;
    @Inject
    ProjectService projectService;
    @Inject
    StatusService statusService;
    @Inject
    TaskParser taskParser;
    @Inject
    OrganizationService orgService;
    @Inject
    UserService userService;
    @Inject
    ResourceBundle bundle;
    @Inject
    SettingService settingService;
    @Inject
    @Path(value="detail.gtmpl")
    detail detail;
    @Inject
    @Path(value="taskLogs.gtmpl")
    taskLogs taskLogs;
    @Inject
    @Path(value="taskComments.gtmpl")
    taskComments taskComments;
    @Inject
    @Path(value="comments.gtmpl")
    comments comments;
    @Inject
    @Path(value="projectTaskListView.gtmpl")
    projectTaskListView taskListView;
    @Inject
    @Path(value="confirmDeleteTask.gtmpl")
    confirmDeleteTask confirmDeleteTask;
    @Inject
    ViewStateService viewStateService;

    @Resource
    @Ajax
    @MimeType.HTML
    public Response detail(Long id, SecurityContext securityContext) throws EntityNotFoundException, UnAuthorizedOperationException {
        Task task = this.taskService.getTask(id.longValue());
        if (!TaskUtil.hasViewPermission((Task)task)) {
            throw new UnAuthorizedOperationException(id, Task.class, this.getNoPermissionMsg());
        }
        TaskModel model = TaskUtil.getTaskModel((Long)id, (boolean)false, (ResourceBundle)this.bundle, (String)securityContext.getRemoteUser(), (TaskService)this.taskService, (OrganizationService)this.orgService, (UserService)this.userService, (ProjectService)this.projectService);
        TimeZone userTimezone = this.userService.getUserTimezone(securityContext.getRemoteUser());
        return this.detail.with().taskModel((Object)model).userTimezone((Object)userTimezone).bundle((Object)this.bundle).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response findLabelByTask(Long taskId, SecurityContext securityContext) throws JSONException {
        String userId = securityContext.getRemoteUser();
        ListAccess labels = null;
        try {
            labels = this.taskService.findLabelsByTask(taskId.longValue(), userId);
        }
        catch (EntityNotFoundException e) {
            this.LOG.error((Object)e);
        }
        JSONArray arr = new JSONArray();
        if (labels != null) {
            for (Label lbl : (Label[])ListUtil.load((ListAccess)labels, (int)0, (int)-1)) {
                JSONObject json = new JSONObject();
                json.put("name", (Object)lbl.getName());
                json.put("color", (Object)lbl.getColor());
                arr.put((Object)json);
            }
        }
        return Response.ok((CharSequence)arr.toString()).withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response renderTaskLogs(Long taskId, SecurityContext securityContext) throws EntityNotFoundException, UnAuthorizedOperationException {
        Task task = this.taskService.getTask(taskId.longValue());
        if (!TaskUtil.hasViewPermission((Task)task)) {
            throw new UnAuthorizedOperationException(taskId, Task.class, this.getNoPermissionMsg());
        }
        ChangeLog[] arr = (ChangeLog[])ListUtil.load((ListAccess)this.taskService.getTaskLogs(taskId.longValue()), (int)0, (int)-1);
        LinkedList<ChangeLog> logs = new LinkedList<ChangeLog>(Arrays.asList(arr));
        Collections.sort(logs);
        HashMap<String, User> userMap = new HashMap<String, User>();
        if (logs.size() > 0) {
            for (ChangeLog log : logs) {
                String target;
                String author = log.getAuthor();
                if (!userMap.containsKey(author)) {
                    User user = this.userService.loadUser(log.getAuthor());
                    userMap.put(author, user);
                }
                if (!"assign".equals(log.getActionName()) && !"unassign".equals(log.getActionName()) || (target = log.getTarget()) == null || userMap.containsKey(target)) continue;
                User user = this.userService.loadUser(target);
                userMap.put(target, user);
            }
        }
        return this.taskLogs.with().bundle((Object)this.bundle).taskLogs(logs).userMap(userMap).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response renderTaskComments(Long id, Boolean loadAllComment, SecurityContext securityContext) throws EntityNotFoundException, UnAuthorizedOperationException {
        Task task = this.taskService.getTask(id.longValue());
        if (!TaskUtil.hasViewPermission((Task)task)) {
            throw new UnAuthorizedOperationException(id, Task.class, this.getNoPermissionMsg());
        }
        if (loadAllComment == null) {
            loadAllComment = Boolean.FALSE;
        }
        TaskModel model = TaskUtil.getTaskModel((Long)id, (boolean)loadAllComment, (ResourceBundle)this.bundle, (String)securityContext.getRemoteUser(), (TaskService)this.taskService, (OrganizationService)this.orgService, (UserService)this.userService, (ProjectService)this.projectService);
        return this.taskComments.with().taskModel((Object)model).bundle((Object)this.bundle).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response clone(Long id) throws EntityNotFoundException, JSONException, UnAuthorizedOperationException {
        Task task = this.taskService.getTask(id.longValue());
        if (!TaskUtil.hasEditPermission((Task)task)) {
            throw new UnAuthorizedOperationException(id, Task.class, this.getNoPermissionMsg());
        }
        Task newTask = this.taskService.cloneTask(id.longValue());
        JSONObject json = new JSONObject();
        json.put("id", newTask.getId());
        return Response.ok((CharSequence)json.toString());
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openConfirmDeleteTask(Long id) throws EntityNotFoundException, UnAuthorizedOperationException {
        Task task = this.taskService.getTask(id.longValue());
        if (!TaskUtil.hasDeletePermission((Task)task)) {
            throw new UnAuthorizedOperationException(id, Task.class, this.getNoPermissionMsg());
        }
        String msg = this.bundle.getString("popup.msg.deleteTask");
        msg = msg.replace("{}", task.getTitle());
        return this.confirmDeleteTask.with().taskId((Object)task.getId()).msg((Object)msg).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response delete(Long id, SecurityContext context) throws EntityNotFoundException, JSONException, UnAuthorizedOperationException {
        Task task = this.taskService.getTask(id.longValue());
        if (!TaskUtil.hasDeletePermission((Task)task)) {
            throw new UnAuthorizedOperationException(id, Task.class, this.getNoPermissionMsg());
        }
        this.taskService.removeTask(id.longValue());
        String username = context.getRemoteUser();
        long taskNum = this.getIncomingNum(username);
        JSONObject json = new JSONObject();
        json.put("id", (Object)id);
        json.put("incomNum", taskNum);
        return Response.ok((CharSequence)json.toString());
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response saveTaskInfo(Long taskId, String name, String[] value, SecurityContext context) throws EntityNotFoundException, ParameterEntityException, UnAuthorizedOperationException {
        TimeZone timezone = this.userService.getUserTimezone(context.getRemoteUser());
        Task task = this.taskService.getTask(taskId.longValue());
        if (!TaskUtil.hasEditPermission((Task)task) || !TaskUtil.hasPermissionOnField((Task)task, (String)name, (String[])value, (StatusService)this.statusService, (TaskService)this.taskService, (ProjectService)this.projectService)) {
            throw new UnAuthorizedOperationException(taskId, Task.class, this.getNoPermissionMsg());
        }
        task = TaskUtil.saveTaskField((Task)task, (String)context.getRemoteUser(), (String)name, (String[])value, (TimeZone)timezone, (TaskService)this.taskService, (StatusService)this.statusService);
        String response = "Update successfully";
        if ("workPlan".equalsIgnoreCase(name)) {
            Calendar start = null;
            Calendar end = null;
            if (task.getStartDate() != null && task.getEndDate() != null) {
                start = DateUtil.newCalendarInstance((TimeZone)timezone);
                start.setTime(task.getStartDate());
                end = DateUtil.newCalendarInstance((TimeZone)timezone);
                end.setTime(task.getEndDate());
            }
            if ((response = TaskUtil.getWorkPlan(start, end, (ResourceBundle)this.bundle)) == null) {
                response = this.bundle.getString("label.noWorkPlan");
            }
        }
        if ("project".equalsIgnoreCase(name) || "assignee".equalsIgnoreCase(name) || "coworker".equalsIgnoreCase(name)) {
            String username = context.getRemoteUser();
            long taskNum = this.getIncomingNum(username);
            response = String.valueOf(taskNum);
        }
        return Response.ok((CharSequence)response);
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response saveDragAndDropTask(Long taskId, Long newStatusId, String groupBy, String oldGroup, String newGroup, Boolean needUpdateOrder, Long[] orders, SecurityContext context) throws EntityNotFoundException, UnAuthorizedOperationException, ParameterEntityException {
        if (taskId == null || taskId == 0L) {
            return Response.status((int)404).body((CharSequence)"Task not found");
        }
        Task task = this.taskService.getTask(taskId.longValue());
        if (!TaskUtil.hasEditPermission((Task)task)) {
            throw new UnAuthorizedOperationException(taskId, Task.class, this.getNoPermissionMsg());
        }
        Status newStatus = null;
        if (newStatusId != null && newStatusId > 0L && !(newStatus = this.statusService.getStatus(newStatusId.longValue())).getProject().canView(ConversationState.getCurrent().getIdentity())) {
            throw new UnAuthorizedOperationException(taskId, Task.class, this.getNoPermissionMsg());
        }
        String username = context.getRemoteUser();
        TimeZone tz = this.userService.getUserTimezone(context.getRemoteUser());
        if (needUpdateOrder != null && needUpdateOrder.booleanValue()) {
            long[] ids = new long[orders.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = orders[i];
            }
            this.taskService.updateTaskOrder(taskId.longValue(), newStatus, ids);
            task = this.taskService.getTask(task.getId());
        } else {
            task = TaskUtil.saveTaskField((Task)task, (String)username, (String)"status", (String[])new String[]{String.valueOf(newStatusId)}, (TimeZone)tz, (TaskService)this.taskService, (StatusService)this.statusService);
        }
        if (!(groupBy == null || "none".equalsIgnoreCase(groupBy) || groupBy.trim().isEmpty() || oldGroup.equalsIgnoreCase(newGroup))) {
            if ("assignee".equalsIgnoreCase(groupBy)) {
                TaskUtil.saveTaskField((Task)task, (String)username, (String)"assignee", (String[])new String[]{newGroup}, (TimeZone)tz, (TaskService)this.taskService, (StatusService)this.statusService);
            } else if ("label".equalsIgnoreCase(groupBy)) {
                long oldLabelId = 0L;
                long newLabelId = 0L;
                try {
                    oldLabelId = oldGroup.isEmpty() ? 0L : Long.parseLong(oldGroup);
                }
                catch (NumberFormatException ex) {
                    throw new ParameterEntityException(Long.valueOf(task.getId()), Task.class, "Label ID", oldGroup, null, (Throwable)ex);
                }
                try {
                    newLabelId = newGroup.isEmpty() ? 0L : Long.parseLong(newGroup);
                }
                catch (NumberFormatException ex) {
                    throw new ParameterEntityException(Long.valueOf(task.getId()), Task.class, "Label ID", newGroup, null, (Throwable)ex);
                }
                ListAccess list = this.taskService.findLabelsByTask(task.getId(), username);
                Label[] labels = (Label[])ListUtil.load((ListAccess)list, (int)0, (int)-1);
                ArrayList<String> newLabelIds = new ArrayList<String>(labels.length + 1);
                for (Label l : labels) {
                    if (l.getId() == oldLabelId) continue;
                    newLabelIds.add(String.valueOf(l.getId()));
                }
                if (newLabelId > 0L) {
                    newLabelIds.add(String.valueOf(newLabelId));
                }
                TaskUtil.saveTaskField((Task)task, (String)username, (String)"labels", (String[])newLabelIds.toArray(new String[newLabelIds.size()]), (TimeZone)tz, (TaskService)this.taskService, (StatusService)this.statusService);
            }
        }
        return Response.ok((CharSequence)"Update successfully");
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response updateCompleted(Long taskId, Boolean completed, SecurityContext securityContext) throws EntityNotFoundException, ParameterEntityException, UnAuthorizedOperationException {
        Task task = this.taskService.getTask(taskId.longValue());
        if (!TaskUtil.hasEditPermission((Task)task)) {
            throw new UnAuthorizedOperationException(taskId, Task.class, this.getNoPermissionMsg());
        }
        task.setCompleted(completed.booleanValue());
        this.taskService.updateTask(task);
        String username = securityContext.getRemoteUser();
        long taskNum = this.getIncomingNum(username);
        return Response.ok((CharSequence)String.valueOf(taskNum));
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response comment(Long taskId, String comment, Long parentCommentId, SecurityContext securityContext) throws EntityNotFoundException, JSONException, UnAuthorizedOperationException {
        Task task = this.taskService.getTask(taskId.longValue());
        String currentUser = securityContext.getRemoteUser();
        if (!TaskUtil.hasViewPermission((Task)task)) {
            throw new UnAuthorizedOperationException(taskId, Task.class, this.getNoPermissionMsg());
        }
        if (parentCommentId == null) {
            parentCommentId = 0L;
        }
        Comment cmt = this.taskService.addComment(taskId.longValue(), parentCommentId.longValue(), currentUser, comment);
        CommentModel model = new CommentModel(cmt, this.userService.loadUser(cmt.getAuthor()), CommentUtil.formatMention((String)cmt.getComment(), (UserService)this.userService));
        SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy HH:mm");
        df.setTimeZone(this.userService.getUserTimezone(currentUser));
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        JSONObject json = new JSONObject();
        json.put("id", model.getId());
        JSONObject user = new JSONObject();
        user.put("username", (Object)encoder.encode(model.getAuthor().getUsername()));
        user.put("displayName", (Object)encoder.encode(model.getAuthor().getDisplayName()));
        user.put("avatar", (Object)model.getAuthor().getAvatar());
        json.put("author", (Object)user);
        json.put("comment", (Object)encoder.encode(model.getComment()));
        json.put("formattedComment", (Object)model.getFormattedComment());
        json.put("createdTime", model.getCreatedTime().getTime());
        json.put("createdTimeString", (Object)df.format(model.getCreatedTime()));
        return Response.ok((CharSequence)json.toString()).withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response loadAllComments(Long taskId, SecurityContext securityContext) throws EntityNotFoundException, UnAuthorizedOperationException {
        Task task = this.taskService.getTask(taskId.longValue());
        if (!TaskUtil.hasViewPermission((Task)task)) {
            throw new UnAuthorizedOperationException(taskId, Task.class, this.getNoPermissionMsg());
        }
        ListAccess cmtAccessList = this.taskService.getComments(task.getId());
        Comment[] cmts = (Comment[])ListUtil.load((ListAccess)cmtAccessList, (int)0, (int)-1);
        this.taskService.loadSubComments(Arrays.asList(cmts));
        ArrayList listComments = new ArrayList(cmts.length);
        for (Comment cmt : cmts) {
            CommentModel commentModel = this.addCommentModel(cmt, listComments);
            if (cmt.getSubComments() == null) continue;
            ArrayList subComments = new ArrayList();
            for (Comment comment : cmt.getSubComments()) {
                this.addCommentModel(comment, subComments);
            }
            commentModel.setSubComments(subComments);
        }
        User currentUser = this.userService.loadUser(securityContext.getRemoteUser());
        return this.comments.with().commentCount((Object)cmts.length).comments(listComments).currentUser((Object)currentUser).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response deleteComment(Long commentId) throws EntityNotFoundException {
        Comment comment = this.taskService.getComment(commentId.longValue());
        Identity currIdentity = ConversationState.getCurrent().getIdentity();
        if (TaskUtil.canDeleteComment((Identity)currIdentity, (Comment)comment)) {
            this.taskService.removeComment(commentId.longValue());
            return Response.ok((CharSequence)"Delete comment successfully!");
        }
        return Response.status((int)401).body((CharSequence)"Only owner or project manager can delete the comment");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Resource
    @Ajax
    @MimeType.HTML
    public Response listTasks(String space_group_id, Long projectId, Long labelId, String filterLabelIds, String statusId, String dueDate, String priority, String assignee, Boolean showCompleted, String keyword, String groupBy, String orderBy, String dueCategory, String viewType, Integer page, SecurityContext securityContext) throws EntityNotFoundException, UnAuthorizedOperationException {
        void var41_42;
        long countTasks;
        Map defOrders;
        Map defGroupBys;
        ViewType vType;
        String listId = ViewState.buildId((Long)projectId, (Long)labelId, (String)dueCategory);
        ViewState viewState = this.viewStateService.getViewState(listId);
        if (orderBy == null) {
            orderBy = viewState.getOrderBy();
        } else {
            viewState.setOrderBy(orderBy);
        }
        if (groupBy == null) {
            groupBy = viewState.getGroupBy();
        } else {
            viewState.setGroupBy(groupBy);
        }
        Identity currIdentity = ConversationState.getCurrent().getIdentity();
        if (projectId <= 0L || viewType == null || viewType.isEmpty()) {
            vType = viewState.getViewType();
        } else {
            vType = ViewType.getViewType((String)viewType);
            viewState.setViewType(vType);
        }
        this.viewStateService.saveViewState(viewState);
        boolean isBoardView = ViewType.BOARD == vType;
        ViewState.Filter filter = this.viewStateService.getFilter(listId);
        boolean advanceSearch = filter.isEnabled();
        if (advanceSearch) {
            filter.updateFilterData(filterLabelIds, statusId, dueDate, priority, assignee, showCompleted, keyword);
        } else if (StringUtils.isNotEmpty((String)keyword)) {
            filter.setKeyword(keyword);
        }
        this.viewStateService.saveFilter(filter);
        Project project = null;
        boolean noProjPermission = false;
        List projectStatuses = Collections.emptyList();
        if (projectId != null && projectId > 0L) {
            project = this.projectService.getProject(projectId);
            if (!project.canView(currIdentity)) {
                if (!advanceSearch) throw new UnAuthorizedOperationException(projectId, Project.class, this.getNoPermissionMsg());
                noProjPermission = true;
            } else if (isBoardView) {
                projectStatuses = this.statusService.getStatuses(projectId.longValue());
            }
        }
        String currentLabelName = "";
        boolean noLblPermission = false;
        if (labelId != null && labelId > 0L) {
            Label label = this.taskService.getLabel(labelId.longValue());
            if (!label.getUsername().equals(currIdentity.getUserId())) {
                if (!advanceSearch) throw new UnAuthorizedOperationException(labelId, Label.class, this.getNoPermissionMsg());
                noLblPermission = true;
            } else {
                currentLabelName = label.getName();
            }
        }
        if (isBoardView) {
            defGroupBys = TaskUtil.resolve(Arrays.asList("none", "label", "assignee"), (ResourceBundle)this.bundle);
            defOrders = TaskUtil.resolve(Arrays.asList("dueDate", "priority", "rank"), (ResourceBundle)this.bundle);
            if (orderBy == null || !defOrders.containsKey(orderBy)) {
                orderBy = "dueDate";
            }
            if (groupBy == null || !defGroupBys.containsKey(groupBy)) {
                groupBy = "none";
            }
        } else {
            defGroupBys = TaskUtil.getDefGroupBys((long)projectId, (ResourceBundle)this.bundle);
            defOrders = TaskUtil.getDefOrders((ResourceBundle)this.bundle);
        }
        String currentUser = securityContext.getRemoteUser();
        TimeZone userTimezone = this.userService.getUserTimezone(currentUser);
        if (currentUser == null || currentUser.isEmpty()) {
            return Response.status((int)401);
        }
        LinkedList<Long> spaceProjectIds = null;
        if (space_group_id != null) {
            spaceProjectIds = new LinkedList<Long>();
            List projects = ProjectUtil.flattenTree((List)ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService), (ProjectService)this.projectService);
            for (Object p : projects) {
                if (!p.canView(currIdentity)) continue;
                spaceProjectIds.add(p.getId());
            }
        }
        LinkedList<Long> allProjectIds = null;
        if (projectId == 0L) {
            allProjectIds = new LinkedList<Long>();
            List projects = ProjectUtil.flattenTree((List)ProjectUtil.getProjectTree(null, (ProjectService)this.projectService), (ProjectService)this.projectService);
            for (Project p : projects) {
                if (!p.canView(currIdentity)) continue;
                allProjectIds.add(p.getId());
            }
        }
        OrderBy.ASC order = null;
        if (orderBy != null && !orderBy.trim().isEmpty()) {
            order = "title".equals(orderBy) || "dueDate".equals(orderBy) ? new OrderBy.ASC(orderBy) : new OrderBy.DESC(orderBy);
        }
        TaskQuery taskQuery = new TaskQuery();
        if (advanceSearch) {
            Status status = filter.getStatus() != null ? this.statusService.getStatus(filter.getStatus().longValue()) : null;
            TaskUtil.buildTaskQuery((TaskQuery)taskQuery, (String)filter.getKeyword(), (List)filter.getLabel(), (Status)status, (TaskUtil.DUE)filter.getDue(), (Priority)filter.getPriority(), (List)filter.getAssignees(), (Boolean)filter.isShowCompleted(), (TimeZone)userTimezone);
        } else {
            taskQuery.setKeyword(keyword);
            taskQuery.setCompleted(Boolean.valueOf(false));
        }
        if (projectId == -1L) {
            if (orderBy == null || orderBy.isEmpty()) {
                orderBy = "createdTime";
            }
            order = new OrderBy.DESC(orderBy);
            taskQuery.setIsIncomingOf(currentUser);
            taskQuery.setOrderBy(Arrays.asList(order));
        } else if (projectId == -2L) {
            defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label", "dueDate"), (ResourceBundle)this.bundle);
            defOrders = TaskUtil.resolve(Arrays.asList("title", "status", "dueDate", "priority", "rank"), (ResourceBundle)this.bundle);
            taskQuery.setIsTodoOf(currentUser);
            if ("overDue".equalsIgnoreCase(dueCategory)) {
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "dueDate"), (ResourceBundle)this.bundle);
                groupBy = groupBy == null || !defGroupBys.containsKey(groupBy) ? "project" : groupBy;
            } else if ("today".equalsIgnoreCase(dueCategory)) {
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "rank"), (ResourceBundle)this.bundle);
                if (orderBy == null) {
                    order = new OrderBy.DESC("priority");
                    orderBy = "priority";
                }
                groupBy = groupBy == null || !defGroupBys.containsKey(groupBy) ? "none" : groupBy;
            } else if ("tomorrow".equalsIgnoreCase(dueCategory)) {
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "rank"), (ResourceBundle)this.bundle);
                if (orderBy == null || !defOrders.containsKey(orderBy)) {
                    order = new OrderBy.DESC("priority");
                    orderBy = "priority";
                }
                groupBy = groupBy == null || !defGroupBys.containsKey(groupBy) ? "none" : groupBy;
            } else if ("upcoming".equalsIgnoreCase(dueCategory)) {
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "dueDate", "rank"), (ResourceBundle)this.bundle);
                String string = groupBy = groupBy == null || !defGroupBys.containsKey(groupBy) ? "none" : groupBy;
            }
            if (orderBy == null || !defOrders.containsKey(orderBy)) {
                orderBy = "dueDate";
                order = new OrderBy.ASC("dueDate");
            }
            if (groupBy == null || !defGroupBys.containsKey(groupBy)) {
                groupBy = "dueDate";
            }
            Date[] filterDate = TaskUtil.convertDueDate((String)dueCategory, (TimeZone)userTimezone);
            taskQuery.setDueDateFrom(filterDate[0]);
            taskQuery.setDueDateTo(filterDate[1]);
            taskQuery.setOrderBy(Arrays.asList(order));
        } else if (projectId >= 0L) {
            if (projectId == 0L) {
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "assignee", "project", "label", "dueDate", "status"), (ResourceBundle)this.bundle);
                if (orderBy == null || orderBy.isEmpty()) {
                    orderBy = "dueDate";
                    order = new OrderBy.ASC(orderBy);
                }
                if (spaceProjectIds != null) {
                    taskQuery.setProjectIds(spaceProjectIds);
                } else {
                    taskQuery.setProjectIds(allProjectIds);
                }
            } else {
                if (orderBy == null || orderBy.isEmpty()) {
                    orderBy = "dueDate";
                    order = new OrderBy.ASC(orderBy);
                }
                if (!noProjPermission) {
                    taskQuery.setProjectIds(Arrays.asList(projectId));
                }
            }
            taskQuery.setOrderBy(Arrays.asList(order));
        } else if (labelId != null && labelId >= 0L) {
            defOrders = TaskUtil.resolve(Arrays.asList("title", "createdTime", "dueDate", "priority"), (ResourceBundle)this.bundle);
            if (orderBy == null || orderBy.isEmpty() || !defOrders.containsKey(orderBy)) {
                orderBy = "dueDate";
                order = new OrderBy.ASC("dueDate");
            }
            if (labelId > 0L) {
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "dueDate", "status"), (ResourceBundle)this.bundle);
                if (groupBy == null || groupBy.isEmpty() || !defGroupBys.containsKey(groupBy)) {
                    groupBy = "none";
                }
                if (!noLblPermission) {
                    taskQuery.setLabelIds(Arrays.asList(labelId));
                }
            } else {
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label", "dueDate", "status"), (ResourceBundle)this.bundle);
                if (groupBy == null || groupBy.isEmpty() || !defGroupBys.containsKey(groupBy)) {
                    groupBy = "label";
                }
                taskQuery.setIsLabelOf(currentUser);
            }
            if (spaceProjectIds != null) {
                taskQuery.setProjectIds(spaceProjectIds);
            }
            taskQuery.setOrderBy(Arrays.asList(order));
        }
        page = page == null ? 1 : page;
        if (page <= 0) {
            page = 1;
        }
        Paging paging2 = new Paging(page.intValue());
        ListAccess listTasks = null;
        listTasks = spaceProjectIds != null && spaceProjectIds.isEmpty() || projectId != null && projectId == 0L && allProjectIds.isEmpty() || noLblPermission && labelId != null && labelId > 0L || noProjPermission && projectId != null && projectId > 0L ? TaskUtil.EMPTY_TASK_LIST : this.taskService.findTasks(taskQuery);
        paging2.setTotal((long)ListUtil.getSize((ListAccess)listTasks));
        if ((long)paging2.getStart() >= paging2.getTotal()) {
            paging2 = new Paging(1);
            paging2.setTotal((long)ListUtil.getSize((ListAccess)listTasks));
        }
        if ((countTasks = paging2.getTotal()) < 2L) {
            groupBy = "none";
        }
        HashMap hashMap = new HashMap();
        if (countTasks >= 2L && groupBy != null && !groupBy.isEmpty() && !"none".equalsIgnoreCase(groupBy)) {
            Map map = TaskUtil.groupTasks(Arrays.asList(ListUtil.load((ListAccess)listTasks, (int)paging2.getStart(), (int)paging2.getNumberItemPerPage())), (String)groupBy, (String)currentUser, (TimeZone)userTimezone, (ResourceBundle)this.bundle, (TaskService)this.taskService, (UserService)this.userService);
        }
        if (var41_42.isEmpty()) {
            var41_42.put(new GroupKey("", null, 0), Arrays.asList(ListUtil.load((ListAccess)listTasks, (int)paging2.getStart(), (int)paging2.getNumberItemPerPage())));
        }
        HashMap<Long, Integer> numberTasks = new HashMap<Long, Integer>();
        if (isBoardView) {
            for (List list : var41_42.values()) {
                for (Task task : list) {
                    Status st = task.getStatus();
                    int num = 0;
                    if (numberTasks.containsKey(st.getId())) {
                        num = (Integer)numberTasks.get(st.getId());
                    }
                    numberTasks.put(st.getId(), ++num);
                }
            }
        }
        long incomNum = -1L;
        if (projectId != -1L || !advanceSearch) return this.taskListView.with().orders((Object)defOrders).groups((Object)defGroupBys).currentProjectId((Object)projectId).project((Object)project).projectStatuses((Object)projectStatuses).tasks(new ArrayList()).taskNum((Object)countTasks).incomNum((Object)incomNum).groupTasks((Object)var41_42).keyword((Object)(keyword == null ? "" : keyword)).showCompleted((Object)(advanceSearch && filter.isShowCompleted() ? 1 : 0)).groupBy((Object)(groupBy == null ? "none" : groupBy)).orderBy((Object)(orderBy == null ? "" : orderBy)).filter((Object)(dueCategory == null ? "" : dueCategory)).advanceSearch((Object)advanceSearch).bundle((Object)this.bundle).viewType((Object)vType).userTimezone((Object)userTimezone).taskService((Object)this.taskService).currentUser((Object)currentUser).currentLabelId((Object)(labelId == null ? -1L : labelId)).currentLabelName((Object)currentLabelName).paging((Object)paging2).set("userMap", new HashMap()).set("numberTasksByStatus", numberTasks).ok().withCharset(Tools.UTF_8);
        TaskQuery q = new TaskQuery();
        q.setIsIncomingOf(currentUser);
        q.setCompleted(Boolean.valueOf(false));
        incomNum = ListUtil.getSize((ListAccess)this.taskService.findTasks(q));
        return this.taskListView.with().orders((Object)defOrders).groups((Object)defGroupBys).currentProjectId((Object)projectId).project((Object)project).projectStatuses((Object)projectStatuses).tasks(new ArrayList()).taskNum((Object)countTasks).incomNum((Object)incomNum).groupTasks((Object)var41_42).keyword((Object)(keyword == null ? "" : keyword)).showCompleted((Object)(advanceSearch && filter.isShowCompleted() ? 1 : 0)).groupBy((Object)(groupBy == null ? "none" : groupBy)).orderBy((Object)(orderBy == null ? "" : orderBy)).filter((Object)(dueCategory == null ? "" : dueCategory)).advanceSearch((Object)advanceSearch).bundle((Object)this.bundle).viewType((Object)vType).userTimezone((Object)userTimezone).taskService((Object)this.taskService).currentUser((Object)currentUser).currentLabelId((Object)(labelId == null ? -1L : labelId)).currentLabelName((Object)currentLabelName).paging((Object)paging2).set("userMap", new HashMap()).set("numberTasksByStatus", numberTasks).ok().withCharset(Tools.UTF_8);
    }

    @Resource(method={HttpMethod.POST})
    @Ajax
    @MimeType.JSON
    public Response createTask(Long projectId, Long labelId, String taskInput, String filter, SecurityContext securityContext) throws EntityNotFoundException, JSONException, UnAuthorizedOperationException {
        if (taskInput == null || taskInput.isEmpty()) {
            return Response.content((int)406, (CharSequence)"Task input must not be null or empty");
        }
        String currentUser = securityContext.getRemoteUser();
        if (currentUser == null || currentUser.isEmpty()) {
            return Response.status((int)401);
        }
        ParserContext context = new ParserContext(this.userService.getUserTimezone(currentUser));
        Task task = this.taskParser.parse(taskInput, context);
        task.setCreatedBy(currentUser);
        Identity identity = ConversationState.getCurrent().getIdentity();
        if (projectId > 0L) {
            Project project = this.projectService.getProject(projectId);
            if (!project.canView(identity)) {
                throw new UnAuthorizedOperationException(projectId, Project.class, this.getNoPermissionMsg());
            }
            Status status = this.statusService.getDefaultStatus(projectId.longValue());
            if (status == null) {
                throw new EntityNotFoundException(projectId.longValue(), Project.class);
            }
            task.setStatus(status);
            task.setCalendarIntegrated(project.isCalendarIntegrated());
        } else if (labelId == null || labelId < 0L) {
            task.setAssignee(currentUser);
            TimeZone userTimezone = this.userService.getUserTimezone(currentUser);
            Calendar dueDate = DateUtil.newCalendarInstance((TimeZone)userTimezone);
            if ("tomorrow".equalsIgnoreCase(filter)) {
                dueDate.add(5, 1);
            } else if ("upcoming".equalsIgnoreCase(filter)) {
                dueDate.add(5, 7);
            } else if (!"today".equalsIgnoreCase(filter)) {
                dueDate = null;
            }
            if (dueDate != null) {
                task.setDueDate(dueDate.getTime());
            }
        }
        Label label = null;
        if (labelId != null && labelId > 0L && !(label = this.taskService.getLabel(labelId.longValue())).getUsername().equals(currentUser)) {
            throw new UnAuthorizedOperationException(labelId, Label.class, this.getNoPermissionMsg());
        }
        this.taskService.createTask(task);
        if (label != null) {
            this.taskService.addTaskToLabel(Long.valueOf(task.getId()), labelId);
        }
        JSONObject detail2 = JsonUtil.buildTaskJSon((Task)task, (ResourceBundle)this.bundle);
        JSONObject json = new JSONObject();
        json.put("id", task.getId());
        json.put("detail", (Object)detail2);
        return Response.ok((CharSequence)json.toString()).withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response createTaskInListView(String space_group_id, String taskTitle, Long projectId, Long statusId, String assignee, String viewType, String groupBy, String orderBy, SecurityContext securityContext) throws EntityNotFoundException, UnAuthorizedOperationException {
        if (taskTitle == null || taskTitle.isEmpty()) {
            return Response.status((int)406).body((CharSequence)"Task title is required");
        }
        Task task = new Task();
        task.setTitle(taskTitle);
        if (assignee != null && !assignee.isEmpty()) {
            task.setAssignee(assignee);
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        if (statusId != null) {
            Status status = this.statusService.getStatus(statusId.longValue());
            if (!status.getProject().canView(identity)) {
                throw new UnAuthorizedOperationException(statusId, Status.class, this.getNoPermissionMsg());
            }
            if (status != null) {
                task.setStatus(status);
            }
        } else if (projectId != null) {
            Project project = this.projectService.getProject(projectId);
            if (!project.canView(identity)) {
                throw new UnAuthorizedOperationException(projectId, Project.class, this.getNoPermissionMsg());
            }
            Status status = this.statusService.getDefaultStatus(projectId.longValue());
            if (status != null) {
                task.setStatus(status);
            }
        }
        this.taskService.createTask(task);
        JSONObject json = JsonUtil.buildTaskJSon((Task)task, (ResourceBundle)this.bundle);
        return Response.ok((CharSequence)json.toString()).withCharset(Tools.UTF_8);
    }

    @Resource(method={HttpMethod.POST})
    @Ajax
    @MimeType.HTML
    public Response removeStatus(String space_group_id, Long statusId, SecurityContext securityContext) throws EntityNotFoundException, NotAllowedOperationOnEntityException, UnAuthorizedOperationException {
        Status status = this.statusService.getStatus(statusId.longValue());
        Identity identity = ConversationState.getCurrent().getIdentity();
        Project project = status.getProject();
        if (!project.canEdit(identity)) {
            throw new UnAuthorizedOperationException(statusId, Status.class, this.getNoPermissionMsg());
        }
        this.statusService.removeStatus(statusId.longValue());
        return this.listTasks(space_group_id, Long.valueOf(project.getId()), null, null, null, null, null, null, null, null, null, null, null, "board", Integer.valueOf(0), securityContext);
    }

    @Resource(method={HttpMethod.POST})
    @Ajax
    @MimeType.HTML
    public Response createStatus(String space_group_id, String name, Long projectId, SecurityContext securityContext) throws EntityNotFoundException, UnAuthorizedOperationException {
        Project project = this.projectService.getProject(projectId);
        if (!project.canEdit(ConversationState.getCurrent().getIdentity())) {
            throw new UnAuthorizedOperationException(projectId, Task.class, this.getNoPermissionMsg());
        }
        this.statusService.createStatus(project, name);
        return this.listTasks(space_group_id, projectId, null, null, null, null, null, null, null, null, null, null, null, "board", Integer.valueOf(0), securityContext);
    }

    private long getIncomingNum(String username) {
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setIsIncomingOf(username);
        taskQuery.setCompleted(Boolean.valueOf(false));
        ListAccess taskListAccess = this.taskService.findTasks(taskQuery);
        return ListUtil.getSize((ListAccess)taskListAccess);
    }

    private CommentModel addCommentModel(Comment cmt, List<CommentModel> listComments) {
        User u = this.userService.loadUser(cmt.getAuthor());
        CommentModel commentModel = new CommentModel(cmt, u, CommentUtil.formatMention((String)cmt.getComment(), (UserService)this.userService));
        listComments.add(commentModel);
        return commentModel;
    }
}

