/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Resource;
import juzu.Response;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.exception.UnAuthorizedOperationException;
import org.exoplatform.task.legacy.service.ProjectService;
import org.exoplatform.task.legacy.service.TaskService;
import org.exoplatform.task.legacy.service.UserService;
import org.exoplatform.task.management.controller.AbstractController;
import org.exoplatform.task.model.User;
import org.exoplatform.task.util.ListUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserController
extends AbstractController {
    @Inject
    OrganizationService orgService;
    @Inject
    private UserService userService;
    @Inject
    private TaskService taskService;
    @Inject
    private SpaceService sService;
    @Inject
    private ProjectService projectService;

    @Resource
    @Ajax
    @MimeType.JSON
    public Response findUser(String query, Long projectId) throws Exception {
        ListAccess list = this.userService.findUserByName(query);
        JSONArray array = new JSONArray();
        Space space = projectId != 0L && this.projectService.getProject(projectId) != null ? this.sService.getSpaceByPrettyName(this.projectService.getProject(projectId).getName()) : null;
        Space spaceProject = this.getSpaceProject(projectId);
        for (User u : (User[])list.load(0, 10)) {
            JSONObject json = new JSONObject();
            if (space != null && !this.sService.isMember(space, u.getUsername()) || spaceProject != null && !this.sService.isMember(spaceProject, u.getUsername())) continue;
            json.put("id", (Object)u.getUsername());
            json.put("text", (Object)u.getDisplayName());
            json.put("avatar", (Object)u.getAvatar());
            array.put((Object)json);
        }
        return Response.ok((CharSequence)array.toString());
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response findUsersToMention(String query, Long projectId) throws Exception {
        ListAccess list = this.userService.findUserByName(query);
        JSONArray array = new JSONArray();
        Space space = projectId != 0L && this.projectService.getProject(projectId) != null ? this.sService.getSpaceByPrettyName(this.projectService.getProject(projectId).getName()) : null;
        Space spaceProject = this.getSpaceProject(projectId);
        for (User u : (User[])list.load(0, 10)) {
            JSONObject json = new JSONObject();
            if (space != null && !this.sService.isMember(space, u.getUsername()) || spaceProject != null && !this.sService.isMember(spaceProject, u.getUsername())) continue;
            json.put("id", (Object)("@" + u.getUsername()));
            json.put("name", (Object)u.getDisplayName());
            json.put("avatar", (Object)u.getAvatar());
            json.put("type", (Object)"contact");
            array.put((Object)json);
        }
        return Response.ok((CharSequence)array.toString());
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response getDisplayNameOfUser(String usernames) throws JSONException {
        if (usernames != null) {
            JSONArray array = new JSONArray();
            for (String username : usernames.split(",")) {
                User user = this.userService.loadUser(username);
                JSONObject json = new JSONObject();
                json.put("id", (Object)user.getUsername());
                json.put("text", (Object)user.getDisplayName());
                json.put("avatar", (Object)user.getAvatar());
                json.put("deleted", user.isDeleted());
                json.put("enable", user.isEnable());
                array.put((Object)json);
            }
            return Response.ok((CharSequence)array.toString()).withCharset(Tools.UTF_8);
        }
        return Response.ok((CharSequence)"[]");
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response showHiddenProject(Boolean show, SecurityContext securityContext) {
        this.userService.showHiddenProject(securityContext.getRemoteUser(), show.booleanValue());
        return Response.ok((CharSequence)"Update successfully");
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response hideProject(Long projectId, Boolean hide) throws EntityNotFoundException, NotAllowedOperationOnEntityException, UnAuthorizedOperationException {
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            this.userService.hideProject(identity, projectId, hide.booleanValue());
        }
        catch (NotAllowedOperationOnEntityException ex) {
            throw new UnAuthorizedOperationException(projectId, Project.class, this.getNoPermissionMsg());
        }
        return Response.ok((CharSequence)"Hide project successfully");
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response findLabel(SecurityContext securityContext) throws JSONException {
        String username = securityContext.getRemoteUser();
        ListAccess tmp = this.taskService.findLabelsByUser(username);
        List<Object> labels = Arrays.asList(ListUtil.load((ListAccess)tmp, (int)0, (int)-1));
        JSONArray array = new JSONArray();
        if (labels != null) {
            for (Label label : labels) {
                JSONObject json = new JSONObject();
                json.put("id", label.getId());
                json.put("text", (Object)label.getName());
                json.put("name", (Object)label.getName());
                json.put("color", (Object)label.getColor());
                array.put((Object)json);
            }
        }
        return Response.ok((CharSequence)array.toString()).withCharset(Tools.UTF_8);
    }

    private Space getSpaceProject(Long projectId) {
        for (String manager : this.projectService.getManager(projectId.longValue())) {
            int index2 = manager.indexOf(58);
            if (index2 <= -1) continue;
            String projectGroupId = manager.substring(index2 + 1);
            return this.sService.getSpaceByGroupId(projectGroupId);
        }
        return null;
    }
}

