/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.model;

import java.util.Objects;
import org.exoplatform.task.management.model.ViewType;

public class ViewState {
    private String id;
    private String orderBy;
    private String groupBy;
    private ViewType viewType;

    public ViewState(String id) {
        this.id = id;
    }

    public ViewState(ViewState viewState) {
        this.id = viewState.id;
        this.orderBy = viewState.orderBy;
        this.groupBy = viewState.groupBy;
        this.viewType = viewState.viewType;
    }

    public String getId() {
        return this.id;
    }

    public static String buildId(Long projectId, Long labelId, String filter) {
        StringBuilder sBuilder = new StringBuilder();
        if (labelId != null && labelId > 0L) {
            sBuilder.append("label@").append(labelId);
        } else if (projectId > 0L) {
            sBuilder.append("project@").append(projectId);
        } else {
            sBuilder.append("due@").append(filter);
        }
        return sBuilder.toString();
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public boolean isEmpty() {
        return this.groupBy == null && this.orderBy == null && this.viewType == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewState viewState = (ViewState)o;
        return Objects.equals(this.id, viewState.id) && Objects.equals(this.orderBy, viewState.orderBy) && Objects.equals(this.groupBy, viewState.groupBy) && this.viewType == viewState.viewType;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.orderBy, this.groupBy, this.viewType);
    }
}

