/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.timetracker.dao.ProjectDAO;
import org.exoplatform.timetracker.dto.Project;
import org.exoplatform.timetracker.entity.ProjectEntity;
import org.exoplatform.timetracker.storage.ClientStorage;
import org.gatein.api.EntityNotFoundException;

public class ProjectStorage {
    private final ProjectDAO projectDAO;
    private final ClientStorage clientStorage;

    public ProjectStorage(ProjectDAO projectDAO, ClientStorage clientStorage) {
        this.projectDAO = projectDAO;
        this.clientStorage = clientStorage;
    }

    public Project createProject(Project project) throws Exception {
        if (project == null) {
            throw new IllegalArgumentException("Project is mandatory");
        }
        ProjectEntity projectEntity = this.toEntity(project);
        project.setId(null);
        projectEntity = (ProjectEntity)this.projectDAO.create(projectEntity);
        return this.toDTO(projectEntity);
    }

    public Project updateProject(Project project) throws Exception {
        if (project == null) {
            throw new IllegalArgumentException("Project is mandatory");
        }
        Long projectId = project.getId();
        ProjectEntity projectEntity = (ProjectEntity)this.projectDAO.find(project.getId());
        if (projectEntity == null) {
            throw new EntityNotFoundException("Project with id " + projectId + " wasn't found");
        }
        projectEntity = this.toEntity(project);
        projectEntity = (ProjectEntity)this.projectDAO.update(projectEntity);
        return this.toDTO(projectEntity);
    }

    public void deleteProject(long projectId) throws EntityNotFoundException {
        if (projectId <= 0L) {
            throw new IllegalArgumentException("ProjectId must be a positive integer");
        }
        ProjectEntity projectEntity = (ProjectEntity)this.projectDAO.find(Long.valueOf(projectId));
        if (projectEntity == null) {
            throw new EntityNotFoundException("Project with id " + projectId + " not found");
        }
        this.projectDAO.delete(projectEntity);
    }

    public Project getProjectById(long ProjectId) {
        if (ProjectId <= 0L) {
            throw new IllegalArgumentException("ProjectId must be a positive integer");
        }
        ProjectEntity ProjectEntity2 = (ProjectEntity)this.projectDAO.find(Long.valueOf(ProjectId));
        return this.toDTO(ProjectEntity2);
    }

    public List<Project> getProjects() {
        List applicatiions = this.projectDAO.findAll();
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public long countProjects() {
        return this.projectDAO.count();
    }

    public Project toDTO(ProjectEntity projectEntity) {
        if (projectEntity == null) {
            return null;
        }
        return new Project(projectEntity.getId(), projectEntity.getCode(), projectEntity.getLabel(), this.clientStorage.toDTO(projectEntity.getClientEntity()));
    }

    public ProjectEntity toEntity(Project project) {
        if (project == null) {
            return null;
        }
        return new ProjectEntity(project.getId(), project.getCode(), project.getLabel(), this.clientStorage.toEntity(project.getClient()));
    }
}

