/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.timetracker.dto.Feature;
import org.exoplatform.timetracker.service.FeatureService;

@Path(value="timetracker/featuresmgn")
@RolesAllowed(value={"users"})
@Api(value="/timetracker", description="Manage and access Features")
public class FeaturesManagementREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(FeaturesManagementREST.class);
    private final String portalContainerName = "portal";
    private final FeatureService featureService;

    public FeaturesManagementREST(FeatureService featureService, PortalContainer container) {
        this.featureService = featureService;
    }

    @GET
    @Path(value="feature")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getFeatures() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.featureService.getFeaturesList()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting Features", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="feature")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new Feature", httpMethod="POST", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createFeature(@ApiParam(value="Feature to save", required=true) Feature feature) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.featureService.createFeature(feature);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating Feature", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-feature parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="feature")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Updates an existing Feature identified by its id", httpMethod="PUT", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateFeature(@ApiParam(value="Feature to update", required=true) Feature feature) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.featureService.updateFeature(feature, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating Feature", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=update-feature parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="feature/{featureId}")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Deletes an existing Feature identified by its id", httpMethod="DELETE", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteFeature(@ApiParam(value="Feature technical id to delete", required=true) @PathParam(value="featureId") Long featureId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.featureService.deleteFeature(featureId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting Feature", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-feature parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    private String getCurrentUserName() {
        ConversationState state = ConversationState.getCurrent();
        return state == null || state.getIdentity() == null ? null : state.getIdentity().getUserId();
    }
}

