/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.dao;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.entity.SalesOrderEntity;

public class SalesOrderDAO
extends GenericDAOJPAImpl<SalesOrderEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(SalesOrderDAO.class);

    public List<SalesOrderEntity> getSalesOrderByClienId(Long clientId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SalesOrderEntity.getSalesOrderByClienId", SalesOrderEntity.class).setParameter("clientId", (Object)clientId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<SalesOrderEntity>();
        }
        catch (Exception e) {
            LOG.error("Error occurred when trying to get list of Sales Order by ClientId {}", new Object[]{clientId, e});
            return new ArrayList<SalesOrderEntity>();
        }
    }
}

