/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.timetracker.dto.Team;
import org.exoplatform.timetracker.dto.TeamMember;
import org.gatein.api.EntityNotFoundException;

public class TeamStorage {
    private final String PARENT_GROUP = "/organization/teams";
    private final IdentityManager identityManager;
    private final OrganizationService organizationService;
    private final GroupHandler groupHandler;
    private final MembershipHandler membershipHandler;
    private static Boolean requestStarted = false;
    private static final Log log = ExoLogger.getLogger(TeamStorage.class);

    public TeamStorage(OrganizationService organizationService, IdentityManager identityManager) {
        this.organizationService = organizationService;
        this.groupHandler = organizationService.getGroupHandler();
        this.membershipHandler = organizationService.getMembershipHandler();
        this.identityManager = identityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Team createTeam(Team team) throws Exception {
        if (team == null) {
            throw new IllegalArgumentException("Team is mandatory");
        }
        try {
            this.startRequest();
            Group groupParent = this.groupHandler.findGroupById("/organization/teams");
            Group group = this.groupHandler.createGroupInstance();
            group.setId(team.getName().replaceAll(" ", "_"));
            group.setLabel(team.getName());
            group.setGroupName(team.getName());
            group.setDescription(team.getDescription());
            group.setParentId("/organization/teams");
            this.groupHandler.addChild(groupParent, group, true);
            this.endRequest();
            Team team2 = this.toDTO(group);
            return team2;
        }
        catch (Exception exception) {
        }
        finally {
            this.endRequest();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Team updateTeam(Team team) {
        if (team == null) {
            throw new IllegalArgumentException("Team is mandatory");
        }
        String teamId = team.getId();
        Group group = null;
        try {
            group = this.groupHandler.findGroupById(teamId);
            if (group == null) {
                throw new EntityNotFoundException("Group with id " + teamId + " wasn't found");
            }
            this.startRequest();
            group.setLabel(team.getName());
            group.setGroupName(team.getName());
            group.setDescription(team.getDescription());
            this.groupHandler.saveGroup(group, true);
            this.endRequest();
        }
        catch (Exception exception) {
        }
        finally {
            this.endRequest();
        }
        return this.toDTO(group);
    }

    public void deleteTeam(String teamId) throws Exception {
        try {
            this.startRequest();
            Group group = this.groupHandler.findGroupById(teamId);
            if (group == null) {
                throw new EntityNotFoundException("froup with id " + teamId + " not found");
            }
            this.groupHandler.removeGroup(group, true);
            this.endRequest();
        }
        catch (Exception exception) {
        }
        finally {
            this.endRequest();
        }
    }

    public Team getTeamById(String teamId) throws Exception {
        Group group = this.groupHandler.findGroupById(teamId);
        return this.toDTO(group);
    }

    public List<Team> getTeams() throws Exception {
        Group parentGroup = this.groupHandler.findGroupById("/organization/teams");
        return this.groupHandler.findGroups(parentGroup).stream().map(this::toDTO).collect(Collectors.toList());
    }

    public List<Team> getTeamsByUser(String userName) throws Exception {
        return this.groupHandler.findGroupsOfUser(userName).stream().map(this::toDTO).collect(Collectors.toList());
    }

    public List<TeamMember> getMembersByTeam(String teamId) throws Exception {
        try {
            Group group = this.groupHandler.findGroupById(teamId);
            List<Membership> memberships = Arrays.asList((Membership[])this.membershipHandler.findAllMembershipsByGroup(group).load(0, -1));
            return memberships.stream().map(teamMemberEntity -> {
                try {
                    return this.toDTO((Membership)teamMemberEntity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<TeamMember> getEmployees(String userName) throws Exception {
        try {
            Group group = this.groupHandler.findGroupById("/spaces/exo_employees");
            List<Membership> memberships = Arrays.asList((Membership[])this.membershipHandler.findAllMembershipsByGroup(group).load(0, -1));
            if (memberships.size() == 0) {
                new ArrayList();
            }
            return memberships.stream().map(teamMemberEntity -> {
                try {
                    return this.toDTO((Membership)teamMemberEntity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<TeamMember>();
        }
    }

    public Team toDTO(Group group) {
        try {
            if (group == null) {
                return null;
            }
            return new Team(group.getId(), group.getLabel(), group.getDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Team> toDtos(List<Group> teams) {
        return teams.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public List<Team> toDtos_(List<String> teams) {
        return teams.stream().map(this::getDtoByGroupId).collect(Collectors.toList());
    }

    public Team getDtoByGroupId(String groupId) {
        try {
            Group group = this.groupHandler.findGroupById(groupId);
            return this.toDTO(group);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTeamMember(TeamMember teamMember) throws Exception {
        if (teamMember == null) {
            throw new IllegalArgumentException("TeamMember is mandatory");
        }
        try {
            this.startRequest();
            Group group = this.groupHandler.findGroupById(teamMember.getTeam().getId());
            User user = this.organizationService.getUserHandler().findUserByName(teamMember.getUserName());
            MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType("member");
            this.membershipHandler.linkMembership(user, group, membershipType, true);
            this.endRequest();
        }
        catch (Exception exception) {
        }
        finally {
            this.endRequest();
        }
    }

    public void deleteTeamMember(String teamMemberId) throws Exception {
        try {
            this.startRequest();
            this.membershipHandler.removeMembership(teamMemberId, true);
            this.endRequest();
        }
        catch (Exception exception) {
        }
        finally {
            this.endRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllTeamMembersByTeam(String teamId) throws Exception {
        try {
            this.startRequest();
            Group group = this.groupHandler.findGroupById(teamId);
            for (Membership membership : (Membership[])this.membershipHandler.findAllMembershipsByGroup(group).load(0, -1)) {
                this.membershipHandler.removeMembership(membership.getId(), true);
            }
            this.endRequest();
        }
        catch (Exception exception) {
        }
        finally {
            this.endRequest();
        }
    }

    public TeamMember getTeamMemberById(String teamMemberId) throws Exception {
        return this.toDTO(this.membershipHandler.findMembership(teamMemberId));
    }

    public TeamMember getMemberByTeamUserAndRole(String teamId, String userName, String role) throws Exception {
        return this.toDTO(this.membershipHandler.findMembershipByUserGroupAndType(userName, teamId, role));
    }

    public TeamMember toDTO(Membership teamMemberEntity) throws Exception {
        if (teamMemberEntity == null) {
            return null;
        }
        TeamMember teamMember = new TeamMember(teamMemberEntity.getId(), teamMemberEntity.getUserName(), teamMemberEntity.getMembershipType(), this.toDTO(this.groupHandler.findGroupById(teamMemberEntity.getGroupId())));
        Identity identity = this.identityManager.getOrCreateIdentity("organization", teamMember.getUserName());
        if (identity != null) {
            teamMember.setFullName(identity.getProfile().getFullName());
        }
        return teamMember;
    }

    private void endRequest() {
        if (requestStarted.booleanValue() && this.organizationService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle)this.organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            requestStarted = false;
        }
    }

    private void startRequest() {
        if (this.organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
            requestStarted = true;
        }
    }
}

