/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.timetracker.entity.ActivityEntity;
import org.exoplatform.timetracker.entity.ClientEntity;
import org.exoplatform.timetracker.entity.ProjectEntity;
import org.exoplatform.timetracker.entity.SalesOrderEntity;

@Entity(name="ActivityRecordEntity")
@ExoEntity
@Table(name="ADDONS_TT_ACTIVITY_RECORD")
@NamedQueries(value={@NamedQuery(name="ActivityRecordEntity.getActivityRecordsByDay", query="SELECT activity FROM ActivityRecordEntity activity where activity.activityDate = :day and activity.userName = :userName "), @NamedQuery(name="ActivityRecordEntity.getLastActivityRecord", query="SELECT activity FROM ActivityRecordEntity activity where  activity.userName = :userName ORDER BY  activity.id DESC")})
public class ActivityRecordEntity {
    @Id
    @SequenceGenerator(name="SEQ_PROJECT_ID", sequenceName="SEQ_PROJECT_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_PROJECT_ID")
    @Column(name="ID")
    private Long id;
    @Column(name="USER_NAME")
    private String userName;
    @Column(name="ACTIVITY_DATE")
    private String activityDate;
    @Column(name="ACTIVITY_TIME")
    private Date activityTime;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="LOCATION")
    private String location;
    @Column(name="OFFICE")
    private String office;
    @Column(name="TIME")
    private Float time;
    @Column(name="PROJECT_VERSION")
    private String projectVersion;
    @ManyToOne
    @JoinColumn(name="CLIENT_ID")
    private ClientEntity clientEntity;
    @ManyToOne
    @JoinColumn(name="ACTIVITY_ID")
    private ActivityEntity activityEntity;
    @ManyToOne
    @JoinColumn(name="SALES_ORDER_ID")
    private SalesOrderEntity salesOrderEntity;
    @Column(name="CREATED_DATE")
    protected Date createdDate;
    @ManyToOne
    @JoinColumn(name="PROJECT_ID")
    private ProjectEntity projectEntity;

    public ActivityRecordEntity() {
    }

    public ActivityRecordEntity(Long id, String userName, String activityDate, Date activityTime, String description, String location, String office, float time, String projectVersion, ClientEntity clientEntity, ProjectEntity projectEntity, ActivityEntity activityEntity, SalesOrderEntity salesOrderEntity, Date createdDate) {
        this.id = id;
        this.userName = userName;
        this.activityDate = activityDate;
        this.activityTime = activityTime;
        this.description = description;
        this.location = location;
        this.office = office;
        this.time = Float.valueOf(time);
        this.salesOrderEntity = salesOrderEntity;
        this.projectVersion = projectVersion;
        this.clientEntity = clientEntity;
        this.projectEntity = projectEntity;
        this.activityEntity = activityEntity;
        this.createdDate = createdDate;
    }

    public Long getId() {
        return this.id;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getActivityDate() {
        return this.activityDate;
    }

    public Date getActivityTime() {
        return this.activityTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOffice() {
        return this.office;
    }

    public Float getTime() {
        return this.time;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public ClientEntity getClientEntity() {
        return this.clientEntity;
    }

    public ActivityEntity getActivityEntity() {
        return this.activityEntity;
    }

    public SalesOrderEntity getSalesOrderEntity() {
        return this.salesOrderEntity;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public ProjectEntity getProjectEntity() {
        return this.projectEntity;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setActivityDate(String activityDate) {
        this.activityDate = activityDate;
    }

    public void setActivityTime(Date activityTime) {
        this.activityTime = activityTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setOffice(String office) {
        this.office = office;
    }

    public void setTime(Float time) {
        this.time = time;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public void setClientEntity(ClientEntity clientEntity) {
        this.clientEntity = clientEntity;
    }

    public void setActivityEntity(ActivityEntity activityEntity) {
        this.activityEntity = activityEntity;
    }

    public void setSalesOrderEntity(SalesOrderEntity salesOrderEntity) {
        this.salesOrderEntity = salesOrderEntity;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public void setProjectEntity(ProjectEntity projectEntity) {
        this.projectEntity = projectEntity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivityRecordEntity)) {
            return false;
        }
        ActivityRecordEntity other = (ActivityRecordEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$activityDate = this.getActivityDate();
        String other$activityDate = other.getActivityDate();
        if (this$activityDate == null ? other$activityDate != null : !this$activityDate.equals(other$activityDate)) {
            return false;
        }
        Date this$activityTime = this.getActivityTime();
        Date other$activityTime = other.getActivityTime();
        if (this$activityTime == null ? other$activityTime != null : !((Object)this$activityTime).equals(other$activityTime)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$office = this.getOffice();
        String other$office = other.getOffice();
        if (this$office == null ? other$office != null : !this$office.equals(other$office)) {
            return false;
        }
        Float this$time = this.getTime();
        Float other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$projectVersion = this.getProjectVersion();
        String other$projectVersion = other.getProjectVersion();
        if (this$projectVersion == null ? other$projectVersion != null : !this$projectVersion.equals(other$projectVersion)) {
            return false;
        }
        ClientEntity this$clientEntity = this.getClientEntity();
        ClientEntity other$clientEntity = other.getClientEntity();
        if (this$clientEntity == null ? other$clientEntity != null : !((Object)this$clientEntity).equals(other$clientEntity)) {
            return false;
        }
        ActivityEntity this$activityEntity = this.getActivityEntity();
        ActivityEntity other$activityEntity = other.getActivityEntity();
        if (this$activityEntity == null ? other$activityEntity != null : !((Object)this$activityEntity).equals(other$activityEntity)) {
            return false;
        }
        SalesOrderEntity this$salesOrderEntity = this.getSalesOrderEntity();
        SalesOrderEntity other$salesOrderEntity = other.getSalesOrderEntity();
        if (this$salesOrderEntity == null ? other$salesOrderEntity != null : !((Object)this$salesOrderEntity).equals(other$salesOrderEntity)) {
            return false;
        }
        Date this$createdDate = this.getCreatedDate();
        Date other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        ProjectEntity this$projectEntity = this.getProjectEntity();
        ProjectEntity other$projectEntity = other.getProjectEntity();
        return !(this$projectEntity == null ? other$projectEntity != null : !((Object)this$projectEntity).equals(other$projectEntity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivityRecordEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $activityDate = this.getActivityDate();
        result = result * 59 + ($activityDate == null ? 43 : $activityDate.hashCode());
        Date $activityTime = this.getActivityTime();
        result = result * 59 + ($activityTime == null ? 43 : ((Object)$activityTime).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $office = this.getOffice();
        result = result * 59 + ($office == null ? 43 : $office.hashCode());
        Float $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $projectVersion = this.getProjectVersion();
        result = result * 59 + ($projectVersion == null ? 43 : $projectVersion.hashCode());
        ClientEntity $clientEntity = this.getClientEntity();
        result = result * 59 + ($clientEntity == null ? 43 : ((Object)$clientEntity).hashCode());
        ActivityEntity $activityEntity = this.getActivityEntity();
        result = result * 59 + ($activityEntity == null ? 43 : ((Object)$activityEntity).hashCode());
        SalesOrderEntity $salesOrderEntity = this.getSalesOrderEntity();
        result = result * 59 + ($salesOrderEntity == null ? 43 : ((Object)$salesOrderEntity).hashCode());
        Date $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        ProjectEntity $projectEntity = this.getProjectEntity();
        result = result * 59 + ($projectEntity == null ? 43 : ((Object)$projectEntity).hashCode());
        return result;
    }

    public String toString() {
        return "ActivityRecordEntity(id=" + this.getId() + ", userName=" + this.getUserName() + ", activityDate=" + this.getActivityDate() + ", activityTime=" + this.getActivityTime() + ", description=" + this.getDescription() + ", location=" + this.getLocation() + ", office=" + this.getOffice() + ", time=" + this.getTime() + ", projectVersion=" + this.getProjectVersion() + ", clientEntity=" + this.getClientEntity() + ", activityEntity=" + this.getActivityEntity() + ", salesOrderEntity=" + this.getSalesOrderEntity() + ", createdDate=" + this.getCreatedDate() + ", projectEntity=" + this.getProjectEntity() + ")";
    }
}

