/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.lang.invoke.CallSite;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.timetracker.dto.Activity;
import org.exoplatform.timetracker.dto.ActivityRecord;
import org.exoplatform.timetracker.dto.RecordsAccessList;
import org.exoplatform.timetracker.dto.Team;
import org.exoplatform.timetracker.service.TeamService;
import org.exoplatform.timetracker.service.TimeTrackerSettingsService;
import org.exoplatform.timetracker.storage.ActivityRecordStorage;

public class ActivityRecordService {
    private static final Log LOG = ExoLogger.getLogger(ActivityRecordService.class);
    private final ActivityRecordStorage activityRecordstorage;
    private final TimeTrackerSettingsService timeTrackerSettingsService;
    private final TeamService teamService;
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public ActivityRecordService(ActivityRecordStorage activityRecordstorage, TimeTrackerSettingsService timeTrackerSettingsService, TeamService teamService) {
        this.activityRecordstorage = activityRecordstorage;
        this.timeTrackerSettingsService = timeTrackerSettingsService;
        this.teamService = teamService;
    }

    public ActivityRecord createActivityRecord(ActivityRecord activityRecord) throws Exception {
        if (activityRecord == null) {
            throw new IllegalArgumentException("ActivityRecord is mandatory");
        }
        return this.activityRecordstorage.createActivityRecord(activityRecord);
    }

    public ActivityRecord updateActivityRecord(ActivityRecord activityRecord, String username) throws Exception {
        if (activityRecord == null) {
            throw new IllegalArgumentException("ActivityRecord is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Long ActivityRecordId = activityRecord.getId();
        if (ActivityRecordId == null) {
            throw new EntityNotFoundException("ActivityRecord with null id wasn't found");
        }
        ActivityRecord storedActivityRecord = this.activityRecordstorage.getActivityRecordById(ActivityRecordId);
        if (storedActivityRecord == null) {
            throw new EntityNotFoundException("ActivityRecord with id " + ActivityRecordId + " wasn't found");
        }
        return this.activityRecordstorage.updateActivityRecord(activityRecord);
    }

    public void deleteActivityRecord(Long activityRecordId, String username) throws EntityNotFoundException, IllegalAccessException {
        if (activityRecordId == null || activityRecordId <= 0L) {
            throw new IllegalArgumentException("ActivityRecordId must be a positive integer");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        ActivityRecord storedActivityRecord = this.activityRecordstorage.getActivityRecordById(activityRecordId);
        if (storedActivityRecord == null) {
            throw new EntityNotFoundException("ActivityRecord with id " + activityRecordId + " not found");
        }
        this.activityRecordstorage.deleteActivityRecord(activityRecordId);
    }

    public List<ActivityRecord> getActivityRecords() {
        return this.activityRecordstorage.getActivityRecords();
    }

    public RecordsAccessList getActivityRecordsList(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office, int offset, int limit, String sortBy, boolean sortDesc) {
        return this.activityRecordstorage.getActivityRecordsList(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office, offset, limit, sortBy, sortDesc);
    }

    public ActivityRecord getLastActivityRecord(String userName) {
        return this.activityRecordstorage.getLastActivityRecord(userName);
    }

    public long countActivityRecords(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office) {
        return this.activityRecordstorage.countActivityRecords(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office);
    }

    public List<ActivityRecord> getUserActivityRecordsList(String day, String userName) {
        return this.activityRecordstorage.getUserActivityRecords(day, userName);
    }

    public String generateTSCode(List<Team> teams, ActivityRecord record, String exportType) {
        String team = "";
        Object tsCode = "";
        if (teams != null && teams.size() > 0) {
            team = teams.get(0).getName();
        }
        tsCode = String.valueOf(record.getActivityTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear());
        tsCode = (String)tsCode + "_" + record.getOffice();
        String type = "";
        String subType = "";
        if (record.getActivity() != null && record.getActivity().getType() != null) {
            type = record.getActivity().getType().getCode();
            tsCode = (String)tsCode + "_" + type;
        }
        if (exportType.equals("fr")) {
            if (record.getActivity() != null && record.getActivity().getSubType() != null) {
                subType = record.getActivity().getSubType().getCode();
                if (subType.equals("FIXP")) {
                    subType = "CONS";
                }
                tsCode = (String)tsCode + "_" + subType;
            }
            if (team.equals("Architects") || team.equals("Designers") || team.equals("Management") || team.equals("Analysts") || team.equals("ITOP")) {
                if (type.equals("SERV") || subType.equals("FIXP") || subType.equals("CONS") || subType.equals("HOST")) {
                    tsCode = (String)tsCode + this.getClient(record);
                }
            } else if (type.equals("SERV") || subType.equals("FIXP") || subType.equals("CONS")) {
                tsCode = (String)tsCode + this.getClient(record);
            }
        } else {
            if (record.getActivity() != null && record.getActivity().getSubType() != null) {
                tsCode = (String)tsCode + "_" + record.getActivity().getSubType().getCode();
            }
            if (team.equals("Analysts") || team.equals("ITOP") || team.equals("Dev Squad")) {
                tsCode = (String)tsCode + this.getClient(record);
            } else if (team.equals("Architects") || team.equals("Designers")) {
                tsCode = (String)tsCode + this.getClient(record) + this.getProject(record) + this.getActivity(record) + this.geSubActivity(record);
            } else if (team.equals("Support")) {
                tsCode = (String)tsCode + this.getClient(record) + this.getActivity(record);
            } else if (team.equals("QA")) {
                tsCode = (String)tsCode + this.getClient(record) + this.getProject(record);
            }
        }
        return tsCode;
    }

    String getProject(ActivityRecord record) {
        Object project = "";
        if (record.getActivity() != null && record.getActivity().getProject() != null) {
            if (record.getActivity().getProject().getCode().equals("<PRJ>")) {
                if (record.getProject() != null) {
                    project = "_" + record.getProject().getCode();
                }
            } else {
                project = "_" + record.getActivity().getProject().getCode();
            }
        }
        return project;
    }

    String getClient(ActivityRecord record) {
        Object client = "";
        if (record.getActivity() != null && record.getActivity().getProject() != null && record.getActivity().getProject().getClient() != null) {
            if (record.getActivity().getProject().getClient().getCode().equals("<CLNT>")) {
                if (record.getClient() != null) {
                    client = "_" + record.getClient().getCode();
                }
            } else {
                client = "_" + record.getActivity().getProject().getClient().getCode();
            }
        }
        return client;
    }

    String getActivity(ActivityRecord record) {
        Object activity = "";
        if (record.getActivity() != null && record.getActivity().getActivityCode() != null) {
            activity = "_" + record.getActivity().getActivityCode().getCode();
        }
        return activity;
    }

    String geSubActivity(ActivityRecord record) {
        Object subActivity = "";
        if (record.getActivity() != null && record.getActivity().getSubActivityCode() != null) {
            subActivity = "_" + record.getActivity().getSubActivityCode().getCode();
        }
        return subActivity;
    }

    public List<ActivityRecord> getUserActivityRecords(String search, long activity, long type, long subType, long activityCode, long subActivityCode, long client, long project, long feature, String fromDate, String toDate, String userName, String location, String office, String sortBy, Boolean sortDesc, Boolean export, String exportType) {
        RecordsAccessList recordsAccessList = this.getActivityRecordsList(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office, 0, 0, sortBy, sortDesc);
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        List<Object> act = new ArrayList();
        ArrayList<ActivityRecord> activityRecordList = new ArrayList<ActivityRecord>();
        LocalDate from_ = LocalDate.now();
        LocalDate to_ = LocalDate.now();
        Activity weekEndActivity = this.timeTrackerSettingsService.getSettings().getWeekEndHolidayActivity();
        try {
            if (StringUtils.isNotEmpty((String)fromDate)) {
                from_ = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(fromDate));
            } else {
                String from = recordsAccessList.getActivityRecords().get(recordsAccessList.getSize().intValue() - 1).getActivityDate();
                from_ = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(from));
            }
            if (StringUtils.isNotEmpty((String)toDate)) {
                to_ = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(toDate));
            } else {
                String to = recordsAccessList.getActivityRecords().get(0).getActivityDate();
                to_ = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(to));
            }
            String office_ = "";
            Object lastAct = null;
            for (LocalDate d : ActivityRecordService.getDatesBetween(from_, to_)) {
                String day = d.format(this.formatter);
                act = recordsAccessList.getActivityRecords().stream().filter(c -> c.getActivityDate().equals(day)).collect(Collectors.toList());
                if (act.size() > 0) {
                    List<ActivityRecord> dailyActivities = new ArrayList<ActivityRecord>();
                    float TimeSum = act.stream().map(x -> x.getTime()).reduce(Float.valueOf(0.0f), (a, b) -> Float.valueOf(a.floatValue() + b.floatValue())).floatValue();
                    for (ActivityRecord activityRecord : act) {
                        activityRecord.setDailyTimeSum(Float.valueOf(TimeSum));
                        if (activityRecord.getActivity() != null && activityRecord.getProject() != null) {
                            activityRecord.getActivity().setProject(activityRecord.getProject());
                            if (activityRecord.getClient() != null) {
                                activityRecord.getActivity().getProject().setClient(activityRecord.getClient());
                            }
                        }
                        if (export.booleanValue()) {
                            activityRecord.setTsCode(this.generateTSCode(this.teamService.getTeamsList(userName), activityRecord, exportType));
                        }
                        if (StringUtils.isNotEmpty((String)activityRecord.getOffice())) {
                            office_ = activityRecord.getOffice();
                        }
                        dailyActivities.add(activityRecord);
                        if (!export.booleanValue()) continue;
                        dailyActivities = this.groupRedendantActivities(dailyActivities);
                    }
                    activityRecordList.addAll(dailyActivities);
                    dailyActivities = new ArrayList();
                    continue;
                }
                Date actDate = Date.from(d.atStartOfDay(ZoneId.systemDefault()).toInstant());
                DayOfWeek dayOfWeek = d.getDayOfWeek();
                if (dayOfWeek.getValue() == 6 || dayOfWeek.getValue() == 7) {
                    ActivityRecord weekEndRecord = new ActivityRecord(null, userName, day, actDate, "Week End", "", office_, null, "", null, weekEndActivity, null, null, identityManager.getOrCreateUserIdentity(userName).getProfile().getFullName(), null);
                    if (export.booleanValue()) {
                        weekEndRecord.setTsCode(this.generateTSCode(this.teamService.getTeamsList(userName), weekEndRecord, exportType));
                    }
                    activityRecordList.add(weekEndRecord);
                    continue;
                }
                activityRecordList.add(new ActivityRecord(null, userName, day, actDate, "", "", "", null, "", null, null, null, null, identityManager.getOrCreateUserIdentity(userName).getProfile().getFullName(), null));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot parse from date, the to date filer will not applied to get the list of activityRecords");
        }
        return activityRecordList;
    }

    public static List<LocalDate> getDatesBetween(LocalDate startDate, LocalDate endDate) {
        long numOfDaysBetween = ChronoUnit.DAYS.between(startDate, endDate);
        return IntStream.iterate(0, i -> i + 1).limit(numOfDaysBetween + 1L).mapToObj(i -> startDate.plusDays(i)).collect(Collectors.toList());
    }

    private List<ActivityRecord> groupRedendantActivities(List<ActivityRecord> activities) {
        HashMap<CallSite, ActivityRecord> activityRecordMap = new HashMap<CallSite, ActivityRecord>();
        for (ActivityRecord activityRecord : activities) {
            String actCode = activityRecord.getActivityDate() + "_" + activityRecord.getDescription() + "_" + activityRecord.getActivity().getCode() + "_" + activityRecord.getActivity().getProject().getCode() + "_" + activityRecord.getActivity().getProject().getClient().getCode();
            ActivityRecord activity = (ActivityRecord)activityRecordMap.get(actCode);
            if (activity != null) {
                activity.setTime(Float.valueOf(activity.getTime().floatValue() + activityRecord.getTime().floatValue()));
                activityRecordMap.put((CallSite)((Object)actCode), activity);
                continue;
            }
            activityRecordMap.put((CallSite)((Object)actCode), activityRecord);
        }
        return new ArrayList<ActivityRecord>(activityRecordMap.values());
    }
}

