/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.timetracker.dto.ActivityRecord;
import org.exoplatform.timetracker.dto.TeamMember;
import org.exoplatform.timetracker.service.ActivityRecordService;
import org.exoplatform.timetracker.service.TeamService;
import org.exoplatform.timetracker.service.TimeTrackerSettingsService;

@Path(value="timetracker/activityRecordrecordsmgn")
@RolesAllowed(value={"users"})
@Tag(name="/timetracker", description="Manage and access ActivityRecord center ActivityRecords")
public class ActivityRecordsManagementREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ActivityRecordsManagementREST.class);
    private final String portalContainerName = "portal";
    private final ActivityRecordService activityRecordService;
    private final TimeTrackerSettingsService timeTrackerSettingsService;
    private final TeamService teamService;

    public ActivityRecordsManagementREST(ActivityRecordService activityRecordService, TimeTrackerSettingsService timeTrackerSettingsService, TeamService teamService, PortalContainer container) {
        this.activityRecordService = activityRecordService;
        this.timeTrackerSettingsService = timeTrackerSettingsService;
        this.teamService = teamService;
    }

    @GET
    @Path(value="activityrecord")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all available subresources of current endpoint", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getActivityRecords() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.activityRecordService.getActivityRecords()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting ActivityRecords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="activityrecord/list")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all available subresources of current endpoint", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getActivityRecordsList(@Context UriInfo uriInfo, @QueryParam(value="search") String search, @QueryParam(value="activity") String activity, @QueryParam(value="type") String type, @QueryParam(value="subType") String subType, @QueryParam(value="activityCode") String activityCode, @QueryParam(value="subActivityCode") String subActivityCode, @QueryParam(value="client") String client, @QueryParam(value="project") String project, @QueryParam(value="feature") String feature, @QueryParam(value="fromDate") String fromDate, @QueryParam(value="toDate") String toDate, @QueryParam(value="userName") String userName, @QueryParam(value="team") String team, @QueryParam(value="location") String location, @QueryParam(value="office") String office, @QueryParam(value="sortby") String sortBy, @QueryParam(value="sortdesc") Boolean sortDesc, @QueryParam(value="export") Boolean export, @QueryParam(value="exportType") String exportType) {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (StringUtils.isEmpty((String)userName)) {
                userName = sourceIdentity.getRemoteId();
            }
            List<ActivityRecord> activityRecordList = new ArrayList<ActivityRecord>();
            if (StringUtils.isNotEmpty((String)team)) {
                List<TeamMember> members = this.teamService.getMembersList(team);
                for (TeamMember teamMember : members) {
                    activityRecordList.addAll(this.activityRecordService.getUserActivityRecords(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, teamMember.getUserName(), location, office, sortBy, sortDesc, export, exportType));
                }
            } else {
                activityRecordList = this.activityRecordService.getUserActivityRecords(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office, sortBy, sortDesc, export, exportType);
            }
            return Response.ok(activityRecordList).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting ActivityRecords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="activityrecord/last")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all available subresources of current endpoint", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getActivityRecordsList(@Context UriInfo uriInfo, @QueryParam(value="userName") String userName) {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (StringUtils.isEmpty((String)userName)) {
                userName = sourceIdentity.getRemoteId();
            }
            return Response.ok((Object)this.activityRecordService.getLastActivityRecord(userName)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting ActivityRecords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="activityrecord/{day}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all available subresources of current endpoint", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getActivityRecords(@PathParam(value="day") String day) {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.activityRecordService.getUserActivityRecordsList(day, sourceIdentity.getRemoteId())).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting ActivityRecords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="activityrecord")
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    @Operation(summary="Creates a new ActivityRecord", method="POST", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createActivityRecord(@Parameter(description="ActivityRecord to save", required=true) ActivityRecord activityRecord) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            if (activityRecord.getActivity() != null && activityRecord.getActivity().getId() == null) {
                activityRecord.setActivity(null);
            }
            if (StringUtils.isEmpty((String)activityRecord.getUserName())) {
                activityRecord.setUserName(sourceIdentity.getRemoteId());
            }
            this.activityRecordService.createActivityRecord(activityRecord);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating ActivityRecord", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-record parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="activityrecord")
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates an existing ActivityRecord identified by its id", method="PUT", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateActivityRecord(@Parameter(description="ActivityRecord to update", required=true) ActivityRecord activityRecord) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.activityRecordService.updateActivityRecord(activityRecord, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating ActivityRecord", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=update-record parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="activityrecord/{activityrecordId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes an existing ActivityRecord identified by its id", method="DELETE", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteActivityRecord(@Parameter(description="ActivityRecord technical id to delete", required=true) @PathParam(value="activityrecordId") Long activityRecordId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.activityRecordService.deleteActivityRecord(activityRecordId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting ActivityRecord", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=remove-record parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    private String getCurrentUserName() {
        ConversationState state = ConversationState.getCurrent();
        return state == null || state.getIdentity() == null ? null : state.getIdentity().getUserId();
    }
}

