/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.dto.Filter;
import org.exoplatform.timetracker.dto.FilterField;
import org.exoplatform.timetracker.dto.FilterModel;
import org.exoplatform.timetracker.storage.FilterStorage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FilterService {
    private static final Log LOG = ExoLogger.getLogger(FilterService.class);
    private final FilterStorage filterStorage;

    public FilterService(FilterStorage filterStorage) {
        this.filterStorage = filterStorage;
    }

    public FilterModel createFilter(FilterModel filter, String userName) throws Exception {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        ArrayList<FilterField> fields = new ArrayList<FilterField>();
        filter.getFilter().setUserName(userName);
        Filter filter_ = this.filterStorage.createFilter(filter.getFilter());
        for (FilterField filterField : filter.getFilterFields()) {
            filterField.setFilter(filter_);
            fields.add(this.filterStorage.createFilterField(filterField));
        }
        return new FilterModel(filter_, this.getFields(filter_.getId()));
    }

    public void deleteFilter(Long filterId) throws EntityNotFoundException, IllegalAccessException {
        if (filterId == null || filterId <= 0L) {
            throw new IllegalArgumentException("FilterId must be a positive integer");
        }
        Filter storedFilter = this.filterStorage.getFilterById(filterId);
        if (storedFilter == null) {
            throw new EntityNotFoundException("Filter with id " + filterId + " not found");
        }
        this.filterStorage.deleteAllFilterFieldsByFilter(filterId);
        this.filterStorage.deleteFilter(filterId);
    }

    public JSONArray getFiltersList(String userName) {
        JSONArray filterModels = new JSONArray();
        try {
            List<Filter> filters = this.filterStorage.getFiltersByUserName(userName);
            for (Filter filter : filters) {
                JSONObject filterObj = new JSONObject();
                JSONObject filterDetails = new JSONObject();
                filterDetails.put("name", (Object)filter.getName());
                filterDetails.put("id", (Object)filter.getId());
                filterDetails.put("userName", (Object)filter.getUserName());
                filterObj.put("filter", (Object)filterDetails);
                filterObj.put("fields", (Object)this.getFields(filter.getId()));
                filterModels.put((Object)filterObj);
            }
        }
        catch (JSONException e) {
            LOG.error("Cannot get filters for user {}", new Object[]{userName, e});
        }
        return filterModels;
    }

    public JSONObject getFields(long filterId) {
        List<FilterField> fieldsList = this.filterStorage.getFilterFieldsByFilter(filterId);
        JSONObject fieldsJson = new JSONObject();
        for (FilterField filterField : fieldsList) {
            try {
                fieldsJson.put(filterField.getName(), (Object)filterField.getValue());
            }
            catch (Exception e) {
                LOG.error("Cannot get fildes for filter {}", new Object[]{filterId, e});
            }
        }
        return fieldsJson;
    }
}

