/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.dto.ActivityRecord;
import org.exoplatform.timetracker.dto.RecordsAccessList;
import org.exoplatform.timetracker.storage.ActivityRecordStorage;

public class ActivityRecordService {
    private static final Log LOG = ExoLogger.getLogger(ActivityRecordService.class);
    private final ActivityRecordStorage activityRecordstorage;

    public ActivityRecordService(ActivityRecordStorage activityRecordstorage) {
        this.activityRecordstorage = activityRecordstorage;
    }

    public ActivityRecord createActivityRecord(ActivityRecord activityRecord) throws Exception {
        if (activityRecord == null) {
            throw new IllegalArgumentException("ActivityRecord is mandatory");
        }
        return this.activityRecordstorage.createActivityRecord(activityRecord);
    }

    public ActivityRecord updateActivityRecord(ActivityRecord activityRecord, String username) throws Exception {
        if (activityRecord == null) {
            throw new IllegalArgumentException("ActivityRecord is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Long ActivityRecordId = activityRecord.getId();
        if (ActivityRecordId == null) {
            throw new EntityNotFoundException("ActivityRecord with null id wasn't found");
        }
        ActivityRecord storedActivityRecord = this.activityRecordstorage.getActivityRecordById(ActivityRecordId);
        if (storedActivityRecord == null) {
            throw new EntityNotFoundException("ActivityRecord with id " + ActivityRecordId + " wasn't found");
        }
        return this.activityRecordstorage.updateActivityRecord(activityRecord);
    }

    public void deleteActivityRecord(Long activityRecordId, String username) throws EntityNotFoundException, IllegalAccessException {
        if (activityRecordId == null || activityRecordId <= 0L) {
            throw new IllegalArgumentException("ActivityRecordId must be a positive integer");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        ActivityRecord storedActivityRecord = this.activityRecordstorage.getActivityRecordById(activityRecordId);
        if (storedActivityRecord == null) {
            throw new EntityNotFoundException("ActivityRecord with id " + activityRecordId + " not found");
        }
        this.activityRecordstorage.deleteActivityRecord(activityRecordId);
    }

    public List<ActivityRecord> getActivityRecords() {
        return this.activityRecordstorage.getActivityRecords();
    }

    public RecordsAccessList getActivityRecordsList(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office, int offset, int limit, String sortBy, boolean sortDesc) {
        return this.activityRecordstorage.getActivityRecordsList(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office, offset, limit, sortBy, sortDesc);
    }

    public ActivityRecord getLastActivityRecord(String userName) {
        return this.activityRecordstorage.getLastActivityRecord(userName);
    }

    public long countActivityRecords(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office) {
        return this.activityRecordstorage.countActivityRecords(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office);
    }

    public List<ActivityRecord> getUserActivityRecordsList(String day, String userName) {
        return this.activityRecordstorage.getUserActivityRecords(day, userName);
    }
}

