/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.dao;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.entity.FilterFieldEntity;

public class FilterFieldDAO
extends GenericDAOJPAImpl<FilterFieldEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(FilterFieldDAO.class);

    public List<FilterFieldEntity> getFieldsByFilter(Long filerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("FilterFieldEntity.getFieldsByFilter", FilterFieldEntity.class).setParameter("filerId", (Object)filerId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<FilterFieldEntity>();
        }
        catch (Exception e) {
            LOG.error("Error occurred when trying to get list of fields by filter {}", new Object[]{filerId, e});
            return new ArrayList<FilterFieldEntity>();
        }
    }
}

