/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.timetracker.dao.LocationDAO;
import org.exoplatform.timetracker.dao.OfficeDAO;
import org.exoplatform.timetracker.dao.WorkTimeDAO;
import org.exoplatform.timetracker.dto.Location;
import org.exoplatform.timetracker.dto.Office;
import org.exoplatform.timetracker.dto.WorkTime;
import org.exoplatform.timetracker.entity.LocationEntity;
import org.exoplatform.timetracker.entity.OfficeEntity;
import org.exoplatform.timetracker.entity.WorkTimeEntity;
import org.gatein.api.EntityNotFoundException;

public class SettingsStorage {
    private final WorkTimeDAO workTimeDAO;
    private final LocationDAO locationDAO;
    private final OfficeDAO officeDAO;

    public SettingsStorage(WorkTimeDAO workTimeDAO, LocationDAO locationDAO, OfficeDAO officeDAO) {
        this.workTimeDAO = workTimeDAO;
        this.locationDAO = locationDAO;
        this.officeDAO = officeDAO;
    }

    public WorkTime createWorkTime(WorkTime workTime) throws Exception {
        if (workTime == null) {
            throw new IllegalArgumentException("WorkTime is mandatory");
        }
        WorkTimeEntity workTimeEntity = this.toWorkTimeEntity(workTime);
        workTime.setId(null);
        workTimeEntity = (WorkTimeEntity)this.workTimeDAO.create(workTimeEntity);
        return this.toWorkTimeDTO(workTimeEntity);
    }

    public WorkTime updateWorkTime(WorkTime workTime) throws Exception {
        if (workTime == null) {
            throw new IllegalArgumentException("WorkTime is mandatory");
        }
        Long workTimeId = workTime.getId();
        WorkTimeEntity workTimeEntity = (WorkTimeEntity)this.workTimeDAO.find(workTime.getId());
        if (workTimeEntity == null) {
            throw new EntityNotFoundException("WorkTime with id " + workTimeId + " wasn't found");
        }
        workTimeEntity = this.toWorkTimeEntity(workTime);
        workTimeEntity = (WorkTimeEntity)this.workTimeDAO.update(workTimeEntity);
        return this.toWorkTimeDTO(workTimeEntity);
    }

    public void deleteWorkTime(long workTimeId) throws EntityNotFoundException {
        if (workTimeId <= 0L) {
            throw new IllegalArgumentException("WorkTimeId must be a positive integer");
        }
        WorkTimeEntity workTimeEntity = (WorkTimeEntity)this.workTimeDAO.find(Long.valueOf(workTimeId));
        if (workTimeEntity == null) {
            throw new EntityNotFoundException("WorkTime with id " + workTimeId + " not found");
        }
        this.workTimeDAO.delete(workTimeEntity);
    }

    public WorkTime getWorkTimeById(long WorkTimeId) {
        if (WorkTimeId <= 0L) {
            throw new IllegalArgumentException("WorkTimeId must be a positive integer");
        }
        WorkTimeEntity WorkTimeEntity2 = (WorkTimeEntity)this.workTimeDAO.find(Long.valueOf(WorkTimeId));
        return this.toWorkTimeDTO(WorkTimeEntity2);
    }

    public List<WorkTime> getWorkTimes() {
        List applicatiions = this.workTimeDAO.findAll();
        return applicatiions.stream().map(this::toWorkTimeDTO).collect(Collectors.toList());
    }

    public long countWorkTimes() {
        return this.workTimeDAO.count();
    }

    public WorkTime toWorkTimeDTO(WorkTimeEntity workTimeEntity) {
        if (workTimeEntity == null) {
            return null;
        }
        return new WorkTime(workTimeEntity.getId(), workTimeEntity.getFrom(), workTimeEntity.getTo(), workTimeEntity.getTime().floatValue(), workTimeEntity.getPeriod(), workTimeEntity.getTeam(), workTimeEntity.getUserId(), this.toOfficeDTO(workTimeEntity.getOfficeEntity()), workTimeEntity.isDefaultTime());
    }

    public WorkTimeEntity toWorkTimeEntity(WorkTime workTime) {
        if (workTime == null) {
            return null;
        }
        return new WorkTimeEntity(workTime.getId(), workTime.getFrom(), workTime.getTo(), workTime.getTime().floatValue(), workTime.getPeriod(), workTime.getTeam(), workTime.getUserId(), this.toOfficeEntity(workTime.getOffice()), workTime.isDefaultTime());
    }

    public Location createLocation(Location location) throws Exception {
        if (location == null) {
            throw new IllegalArgumentException("Location is mandatory");
        }
        LocationEntity locationEntity = this.toLocationEntity(location);
        locationEntity = (LocationEntity)this.locationDAO.create(locationEntity);
        return this.toLocationDTO(locationEntity);
    }

    public Location updateLocation(Location location) throws Exception {
        if (location == null) {
            throw new IllegalArgumentException("Location is mandatory");
        }
        LocationEntity locationEntity = (LocationEntity)this.locationDAO.find((Serializable)((Object)location.getCode()));
        if (locationEntity == null) {
            throw new EntityNotFoundException("Location with id " + location.getCode() + " wasn't found");
        }
        locationEntity = this.toLocationEntity(location);
        locationEntity = (LocationEntity)this.locationDAO.update(locationEntity);
        return this.toLocationDTO(locationEntity);
    }

    public void deleteLocation(String code) throws EntityNotFoundException {
        LocationEntity locationEntity = (LocationEntity)this.locationDAO.find((Serializable)((Object)code));
        if (locationEntity == null) {
            throw new EntityNotFoundException("Location with code " + code + " not found");
        }
        this.locationDAO.delete(locationEntity);
    }

    public Location getLocationByCode(String code) {
        LocationEntity LocationEntity2 = (LocationEntity)this.locationDAO.find((Serializable)((Object)code));
        return this.toLocationDTO(LocationEntity2);
    }

    public List<Location> getLocations() {
        List applicatiions = this.locationDAO.findAll();
        return applicatiions.stream().map(this::toLocationDTO).collect(Collectors.toList());
    }

    public long countLocations() {
        return this.locationDAO.count();
    }

    public Location toLocationDTO(LocationEntity locationEntity) {
        if (locationEntity == null) {
            return null;
        }
        return new Location(locationEntity.getCode(), locationEntity.getLabel());
    }

    public LocationEntity toLocationEntity(Location location) {
        if (location == null) {
            return null;
        }
        return new LocationEntity(location.getCode(), location.getLabel());
    }

    public Office createOffice(Office office) throws Exception {
        if (office == null) {
            throw new IllegalArgumentException("Office is mandatory");
        }
        OfficeEntity officeEntity = this.toOfficeEntity(office);
        officeEntity = (OfficeEntity)this.officeDAO.create(officeEntity);
        return this.toOfficeDTO(officeEntity);
    }

    public Office updateOffice(Office office) throws Exception {
        if (office == null) {
            throw new IllegalArgumentException("Office is mandatory");
        }
        OfficeEntity officeEntity = (OfficeEntity)this.officeDAO.find((Serializable)((Object)office.getCode()));
        if (officeEntity == null) {
            throw new EntityNotFoundException("Office with id " + office.getCode() + " wasn't found");
        }
        officeEntity = this.toOfficeEntity(office);
        officeEntity = (OfficeEntity)this.officeDAO.update(officeEntity);
        return this.toOfficeDTO(officeEntity);
    }

    public void deleteOffice(String code) throws EntityNotFoundException {
        OfficeEntity officeEntity = (OfficeEntity)this.officeDAO.find((Serializable)((Object)code));
        if (officeEntity == null) {
            throw new EntityNotFoundException("Office with id " + code + " not found");
        }
        this.officeDAO.delete(officeEntity);
    }

    public Office getOfficeByCode(String code) {
        OfficeEntity OfficeEntity2 = (OfficeEntity)this.officeDAO.find((Serializable)((Object)code));
        return this.toOfficeDTO(OfficeEntity2);
    }

    public List<Office> getOffices() {
        List applicatiions = this.officeDAO.findAll();
        return applicatiions.stream().map(this::toOfficeDTO).collect(Collectors.toList());
    }

    public long countOffices() {
        return this.officeDAO.count();
    }

    public Office toOfficeDTO(OfficeEntity officeEntity) {
        if (officeEntity == null) {
            return null;
        }
        return new Office(officeEntity.getCode(), officeEntity.getLabel());
    }

    public OfficeEntity toOfficeEntity(Office office) {
        if (office == null) {
            return null;
        }
        return new OfficeEntity(office.getCode(), office.getLabel());
    }
}

