/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.dto.Feature;
import org.exoplatform.timetracker.storage.FeatureStorage;

public class FeatureService {
    private static final Log LOG = ExoLogger.getLogger(FeatureService.class);
    private final FeatureStorage featureStorage;

    public FeatureService(FeatureStorage featureStorage) {
        this.featureStorage = featureStorage;
    }

    public Feature createFeature(Feature feature) throws Exception {
        if (feature == null) {
            throw new IllegalArgumentException("Feature is mandatory");
        }
        return this.featureStorage.createFeature(feature);
    }

    public Feature updateFeature(Feature Feature2, String username) throws Exception {
        if (Feature2 == null) {
            throw new IllegalArgumentException("Feature is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Long FeatureId = Feature2.getId();
        if (FeatureId == null) {
            throw new EntityNotFoundException("Feature with null id wasn't found");
        }
        Feature storedFeature = this.featureStorage.getFeatureById(FeatureId);
        if (storedFeature == null) {
            throw new EntityNotFoundException("Feature with id " + FeatureId + " wasn't found");
        }
        return this.featureStorage.updateFeature(Feature2);
    }

    public void deleteFeature(Long featureId, String username) throws EntityNotFoundException, IllegalAccessException {
        if (featureId == null || featureId <= 0L) {
            throw new IllegalArgumentException("FeatureId must be a positive integer");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Feature storedFeature = this.featureStorage.getFeatureById(featureId);
        if (storedFeature == null) {
            throw new EntityNotFoundException("Feature with id " + featureId + " not found");
        }
        this.featureStorage.deleteFeature(featureId);
    }

    public List<Feature> getFeaturesList() {
        return this.featureStorage.getFeatures();
    }
}

