/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.timetracker.dao.FilterDAO;
import org.exoplatform.timetracker.dao.FilterFieldDAO;
import org.exoplatform.timetracker.dto.Filter;
import org.exoplatform.timetracker.dto.FilterField;
import org.exoplatform.timetracker.entity.FilterEntity;
import org.exoplatform.timetracker.entity.FilterFieldEntity;
import org.gatein.api.EntityNotFoundException;

public class FilterStorage {
    private final FilterDAO filterDAO;
    private final FilterFieldDAO filterFieldDAO;

    public FilterStorage(FilterDAO filterDAO, FilterFieldDAO filterFieldDAO) {
        this.filterDAO = filterDAO;
        this.filterFieldDAO = filterFieldDAO;
    }

    public Filter createFilter(Filter filter) throws Exception {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        FilterEntity filterEntity = this.toEntity(filter);
        filter.setId(null);
        filterEntity = (FilterEntity)this.filterDAO.create(filterEntity);
        return this.toDTO(filterEntity);
    }

    public Filter updateFilter(Filter filter) throws Exception {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        Long filterId = filter.getId();
        FilterEntity filterEntity = (FilterEntity)this.filterDAO.find(filter.getId());
        if (filterEntity == null) {
            throw new EntityNotFoundException("Filter with id " + filterId + " wasn't found");
        }
        filterEntity = this.toEntity(filter);
        filterEntity = (FilterEntity)this.filterDAO.update(filterEntity);
        return this.toDTO(filterEntity);
    }

    public void deleteFilter(long filterId) throws EntityNotFoundException {
        if (filterId <= 0L) {
            throw new IllegalArgumentException("FilterId must be a positive integer");
        }
        FilterEntity filterEntity = (FilterEntity)this.filterDAO.find(Long.valueOf(filterId));
        if (filterEntity == null) {
            throw new EntityNotFoundException("Filter with id " + filterId + " not found");
        }
        this.filterDAO.delete(filterEntity);
    }

    public Filter getFilterById(long FilterId) {
        if (FilterId <= 0L) {
            throw new IllegalArgumentException("FilterId must be a positive integer");
        }
        FilterEntity FilterEntity2 = (FilterEntity)this.filterDAO.find(Long.valueOf(FilterId));
        return this.toDTO(FilterEntity2);
    }

    public List<Filter> getFilters() {
        List applicatiions = this.filterDAO.findAll();
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public List<Filter> getFiltersByUserName(String userName) {
        List<FilterEntity> applicatiions = this.filterDAO.getFiltersByUserName(userName);
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public long countFilters() {
        return this.filterDAO.count();
    }

    public Filter toDTO(FilterEntity filterEntity) {
        if (filterEntity == null) {
            return null;
        }
        return new Filter(filterEntity.getId(), filterEntity.getName(), filterEntity.getUserName());
    }

    public FilterEntity toEntity(Filter filter) {
        if (filter == null) {
            return null;
        }
        return new FilterEntity(filter.getId(), filter.getName(), filter.getUserName());
    }

    public FilterField createFilterField(FilterField filterField) throws Exception {
        if (filterField == null) {
            throw new IllegalArgumentException("FilterField is mandatory");
        }
        FilterFieldEntity filterFieldEntity = this.toEntity(filterField);
        filterField.setId(null);
        filterFieldEntity = (FilterFieldEntity)this.filterFieldDAO.create(filterFieldEntity);
        return this.toDTO(filterFieldEntity);
    }

    public FilterField updateFilterField(FilterField filterField) throws Exception {
        if (filterField == null) {
            throw new IllegalArgumentException("FilterField is mandatory");
        }
        Long filterFieldId = filterField.getId();
        FilterFieldEntity filterFieldEntity = (FilterFieldEntity)this.filterFieldDAO.find(filterField.getId());
        if (filterFieldEntity == null) {
            throw new EntityNotFoundException("FilterField with id " + filterFieldId + " wasn't found");
        }
        filterFieldEntity = this.toEntity(filterField);
        filterFieldEntity = (FilterFieldEntity)this.filterFieldDAO.update(filterFieldEntity);
        return this.toDTO(filterFieldEntity);
    }

    public void deleteFilterField(long filterFieldId) throws EntityNotFoundException {
        if (filterFieldId <= 0L) {
            throw new IllegalArgumentException("FilterFieldId must be a positive integer");
        }
        FilterFieldEntity filterFieldEntity = (FilterFieldEntity)this.filterFieldDAO.find(Long.valueOf(filterFieldId));
        if (filterFieldEntity == null) {
            throw new EntityNotFoundException("FilterField with id " + filterFieldId + " not found");
        }
        this.filterFieldDAO.delete(filterFieldEntity);
    }

    public void deleteAllFilterFieldsByFilter(long filterFieldId) throws EntityNotFoundException {
        if (filterFieldId <= 0L) {
            throw new IllegalArgumentException("FilterFieldId must be a positive integer");
        }
        List<FilterFieldEntity> filterFieldEntities = this.filterFieldDAO.getFieldsByFilter(filterFieldId);
        this.filterFieldDAO.deleteAll(filterFieldEntities);
    }

    public FilterField getFilterFieldById(long FilterFieldId) {
        if (FilterFieldId <= 0L) {
            throw new IllegalArgumentException("FilterFieldId must be a positive integer");
        }
        FilterFieldEntity FilterFieldEntity2 = (FilterFieldEntity)this.filterFieldDAO.find(Long.valueOf(FilterFieldId));
        return this.toDTO(FilterFieldEntity2);
    }

    public List<FilterField> getFilterFields() {
        List applicatiions = this.filterFieldDAO.findAll();
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public List<FilterField> getFilterFieldsByFilter(long filterId) {
        List<FilterFieldEntity> applicatiions = this.filterFieldDAO.getFieldsByFilter(filterId);
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public long countFilterFields() {
        return this.filterFieldDAO.count();
    }

    public FilterField toDTO(FilterFieldEntity filterFieldEntity) {
        if (filterFieldEntity == null) {
            return null;
        }
        return new FilterField(filterFieldEntity.getId(), filterFieldEntity.getName(), filterFieldEntity.getValue(), this.toDTO(filterFieldEntity.getFilterEntity()));
    }

    public FilterFieldEntity toEntity(FilterField filterField) {
        if (filterField == null) {
            return null;
        }
        return new FilterFieldEntity(filterField.getId(), filterField.getName(), filterField.getValue(), this.toEntity(filterField.getFilter()));
    }
}

