/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.timetracker.dao.ActivityCodeDAO;
import org.exoplatform.timetracker.dao.SubActivityCodeDAO;
import org.exoplatform.timetracker.dao.SubTypeDAO;
import org.exoplatform.timetracker.dao.TypeDAO;
import org.exoplatform.timetracker.dto.ActivityCode;
import org.exoplatform.timetracker.dto.SubActivityCode;
import org.exoplatform.timetracker.dto.SubType;
import org.exoplatform.timetracker.dto.Type;
import org.exoplatform.timetracker.entity.ActivityCodeEntity;
import org.exoplatform.timetracker.entity.SubActivityCodeEntity;
import org.exoplatform.timetracker.entity.SubTypeEntity;
import org.exoplatform.timetracker.entity.TypeEntity;
import org.gatein.api.EntityNotFoundException;

public class CodesStorage {
    private final ActivityCodeDAO activityCodeDAO;
    private final SubActivityCodeDAO subActivityCodeDAO;
    private final TypeDAO typeDAO;
    private final SubTypeDAO subTypeDAO;

    public CodesStorage(ActivityCodeDAO activityCodeDAO, SubActivityCodeDAO subActivityCodeDAO, TypeDAO typeDAO, SubTypeDAO subTypeDAO) {
        this.activityCodeDAO = activityCodeDAO;
        this.subActivityCodeDAO = subActivityCodeDAO;
        this.typeDAO = typeDAO;
        this.subTypeDAO = subTypeDAO;
    }

    public ActivityCode createActivityCode(ActivityCode activityCode) throws Exception {
        if (activityCode == null) {
            throw new IllegalArgumentException("ActivityCode is mandatory");
        }
        ActivityCodeEntity activityCodeEntity = this.toActivityCodeEntity(activityCode);
        activityCode.setId(null);
        activityCodeEntity = (ActivityCodeEntity)this.activityCodeDAO.create(activityCodeEntity);
        return this.toActivityCodeDTO(activityCodeEntity);
    }

    public ActivityCode updateActivityCode(ActivityCode activityCode) throws Exception {
        if (activityCode == null) {
            throw new IllegalArgumentException("ActivityCode is mandatory");
        }
        Long activityCodeId = activityCode.getId();
        ActivityCodeEntity activityCodeEntity = (ActivityCodeEntity)this.activityCodeDAO.find(activityCode.getId());
        if (activityCodeEntity == null) {
            throw new EntityNotFoundException("ActivityCode with id " + activityCodeId + " wasn't found");
        }
        activityCodeEntity = this.toActivityCodeEntity(activityCode);
        activityCodeEntity = (ActivityCodeEntity)this.activityCodeDAO.update(activityCodeEntity);
        return this.toActivityCodeDTO(activityCodeEntity);
    }

    public void deleteActivityCode(long activityCodeId) throws EntityNotFoundException {
        if (activityCodeId <= 0L) {
            throw new IllegalArgumentException("ActivityCodeId must be a positive integer");
        }
        ActivityCodeEntity activityCodeEntity = (ActivityCodeEntity)this.activityCodeDAO.find(Long.valueOf(activityCodeId));
        if (activityCodeEntity == null) {
            throw new EntityNotFoundException("ActivityCode with id " + activityCodeId + " not found");
        }
        this.activityCodeDAO.delete(activityCodeEntity);
    }

    public ActivityCode getActivityCodeById(long ActivityCodeId) {
        if (ActivityCodeId <= 0L) {
            throw new IllegalArgumentException("ActivityCodeId must be a positive integer");
        }
        ActivityCodeEntity ActivityCodeEntity2 = (ActivityCodeEntity)this.activityCodeDAO.find(Long.valueOf(ActivityCodeId));
        return this.toActivityCodeDTO(ActivityCodeEntity2);
    }

    public List<ActivityCode> getActivityCodes() {
        List applicatiions = this.activityCodeDAO.findAll();
        return applicatiions.stream().map(this::toActivityCodeDTO).collect(Collectors.toList());
    }

    public long countActivityCodes() {
        return this.activityCodeDAO.count();
    }

    public ActivityCode toActivityCodeDTO(ActivityCodeEntity activityCodeEntity) {
        if (activityCodeEntity == null) {
            return null;
        }
        return new ActivityCode(activityCodeEntity.getId(), activityCodeEntity.getCode(), activityCodeEntity.getLabel());
    }

    public ActivityCodeEntity toActivityCodeEntity(ActivityCode activityCode) {
        if (activityCode == null) {
            return null;
        }
        return new ActivityCodeEntity(activityCode.getId(), activityCode.getCode(), activityCode.getLabel());
    }

    public SubActivityCode createSubActivityCode(SubActivityCode subActivityCode) throws Exception {
        if (subActivityCode == null) {
            throw new IllegalArgumentException("SubActivityCode is mandatory");
        }
        SubActivityCodeEntity subActivityCodeEntity = this.toSubActivityCodeEntity(subActivityCode);
        subActivityCode.setId(null);
        subActivityCodeEntity = (SubActivityCodeEntity)this.subActivityCodeDAO.create(subActivityCodeEntity);
        return this.toSubActivityCodeDTO(subActivityCodeEntity);
    }

    public SubActivityCode updateSubActivityCode(SubActivityCode subActivityCode) throws Exception {
        if (subActivityCode == null) {
            throw new IllegalArgumentException("SubActivityCode is mandatory");
        }
        Long subActivityCodeId = subActivityCode.getId();
        SubActivityCodeEntity subActivityCodeEntity = (SubActivityCodeEntity)this.subActivityCodeDAO.find(subActivityCode.getId());
        if (subActivityCodeEntity == null) {
            throw new EntityNotFoundException("SubActivityCode with id " + subActivityCodeId + " wasn't found");
        }
        subActivityCodeEntity = this.toSubActivityCodeEntity(subActivityCode);
        subActivityCodeEntity = (SubActivityCodeEntity)this.subActivityCodeDAO.update(subActivityCodeEntity);
        return this.toSubActivityCodeDTO(subActivityCodeEntity);
    }

    public void deleteSubActivityCode(long subActivityCodeId) throws EntityNotFoundException {
        if (subActivityCodeId <= 0L) {
            throw new IllegalArgumentException("SubActivityCodeId must be a positive integer");
        }
        SubActivityCodeEntity subActivityCodeEntity = (SubActivityCodeEntity)this.subActivityCodeDAO.find(Long.valueOf(subActivityCodeId));
        if (subActivityCodeEntity == null) {
            throw new EntityNotFoundException("SubActivityCode with id " + subActivityCodeId + " not found");
        }
        this.subActivityCodeDAO.delete(subActivityCodeEntity);
    }

    public SubActivityCode getSubActivityCodeById(long SubActivityCodeId) {
        if (SubActivityCodeId <= 0L) {
            throw new IllegalArgumentException("SubActivityCodeId must be a positive integer");
        }
        SubActivityCodeEntity SubActivityCodeEntity2 = (SubActivityCodeEntity)this.subActivityCodeDAO.find(Long.valueOf(SubActivityCodeId));
        return this.toSubActivityCodeDTO(SubActivityCodeEntity2);
    }

    public List<SubActivityCode> getSubActivityCodes() {
        List applicatiions = this.subActivityCodeDAO.findAll();
        return applicatiions.stream().map(this::toSubActivityCodeDTO).collect(Collectors.toList());
    }

    public long countSubActivityCodes() {
        return this.subActivityCodeDAO.count();
    }

    public SubActivityCode toSubActivityCodeDTO(SubActivityCodeEntity subActivityCodeEntity) {
        if (subActivityCodeEntity == null) {
            return null;
        }
        return new SubActivityCode(subActivityCodeEntity.getId(), subActivityCodeEntity.getCode(), subActivityCodeEntity.getLabel());
    }

    public SubActivityCodeEntity toSubActivityCodeEntity(SubActivityCode subActivityCode) {
        if (subActivityCode == null) {
            return null;
        }
        return new SubActivityCodeEntity(subActivityCode.getId(), subActivityCode.getCode(), subActivityCode.getLabel());
    }

    public Type createType(Type type) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("Type is mandatory");
        }
        TypeEntity typeEntity = this.toTypeEntity(type);
        type.setId(null);
        typeEntity = (TypeEntity)this.typeDAO.create(typeEntity);
        return this.toTypeDTO(typeEntity);
    }

    public Type updateType(Type type) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("Type is mandatory");
        }
        Long typeId = type.getId();
        TypeEntity typeEntity = (TypeEntity)this.typeDAO.find(type.getId());
        if (typeEntity == null) {
            throw new EntityNotFoundException("Type with id " + typeId + " wasn't found");
        }
        typeEntity = this.toTypeEntity(type);
        typeEntity = (TypeEntity)this.typeDAO.update(typeEntity);
        return this.toTypeDTO(typeEntity);
    }

    public void deleteType(long typeId) throws EntityNotFoundException {
        if (typeId <= 0L) {
            throw new IllegalArgumentException("TypeId must be a positive integer");
        }
        TypeEntity typeEntity = (TypeEntity)this.typeDAO.find(Long.valueOf(typeId));
        if (typeEntity == null) {
            throw new EntityNotFoundException("Type with id " + typeId + " not found");
        }
        this.typeDAO.delete(typeEntity);
    }

    public Type getTypeById(long TypeId) {
        if (TypeId <= 0L) {
            throw new IllegalArgumentException("TypeId must be a positive integer");
        }
        TypeEntity TypeEntity2 = (TypeEntity)this.typeDAO.find(Long.valueOf(TypeId));
        return this.toTypeDTO(TypeEntity2);
    }

    public List<Type> getTypes() {
        List applicatiions = this.typeDAO.findAll();
        return applicatiions.stream().map(this::toTypeDTO).collect(Collectors.toList());
    }

    public long countTypes() {
        return this.typeDAO.count();
    }

    public Type toTypeDTO(TypeEntity typeEntity) {
        if (typeEntity == null) {
            return null;
        }
        return new Type(typeEntity.getId(), typeEntity.getCode(), typeEntity.getLabel());
    }

    public TypeEntity toTypeEntity(Type type) {
        if (type == null) {
            return null;
        }
        return new TypeEntity(type.getId(), type.getCode(), type.getLabel());
    }

    public SubType createSubType(SubType subType) throws Exception {
        if (subType == null) {
            throw new IllegalArgumentException("SubType is mandatory");
        }
        SubTypeEntity subTypeEntity = this.toSubTypeEntity(subType);
        subType.setId(null);
        subTypeEntity = (SubTypeEntity)this.subTypeDAO.create(subTypeEntity);
        return this.toSubTypeDTO(subTypeEntity);
    }

    public SubType updateSubType(SubType subType) throws Exception {
        if (subType == null) {
            throw new IllegalArgumentException("SubType is mandatory");
        }
        Long subTypeId = subType.getId();
        SubTypeEntity subTypeEntity = (SubTypeEntity)this.subTypeDAO.find(subType.getId());
        if (subTypeEntity == null) {
            throw new EntityNotFoundException("SubType with id " + subTypeId + " wasn't found");
        }
        subTypeEntity = this.toSubTypeEntity(subType);
        subTypeEntity = (SubTypeEntity)this.subTypeDAO.update(subTypeEntity);
        return this.toSubTypeDTO(subTypeEntity);
    }

    public void deleteSubType(long subTypeId) throws EntityNotFoundException {
        if (subTypeId <= 0L) {
            throw new IllegalArgumentException("SubTypeId must be a positive integer");
        }
        SubTypeEntity subTypeEntity = (SubTypeEntity)this.subTypeDAO.find(Long.valueOf(subTypeId));
        if (subTypeEntity == null) {
            throw new EntityNotFoundException("SubType with id " + subTypeId + " not found");
        }
        this.subTypeDAO.delete(subTypeEntity);
    }

    public SubType getSubTypeById(long SubTypeId) {
        if (SubTypeId <= 0L) {
            throw new IllegalArgumentException("SubTypeId must be a positive integer");
        }
        SubTypeEntity SubTypeEntity2 = (SubTypeEntity)this.subTypeDAO.find(Long.valueOf(SubTypeId));
        return this.toSubTypeDTO(SubTypeEntity2);
    }

    public List<SubType> getSubTypes() {
        List applicatiions = this.subTypeDAO.findAll();
        return applicatiions.stream().map(this::toSubTypeDTO).collect(Collectors.toList());
    }

    public long countSubTypes() {
        return this.subTypeDAO.count();
    }

    public SubType toSubTypeDTO(SubTypeEntity subTypeEntity) {
        if (subTypeEntity == null) {
            return null;
        }
        return new SubType(subTypeEntity.getId(), subTypeEntity.getCode(), subTypeEntity.getLabel(), this.toTypeDTO(subTypeEntity.getTypeEntity()));
    }

    public SubTypeEntity toSubTypeEntity(SubType subType) {
        if (subType == null) {
            return null;
        }
        return new SubTypeEntity(subType.getId(), subType.getCode(), subType.getLabel(), this.toTypeEntity(subType.getType()));
    }
}

