/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.timetracker.entity.ActivityCodeEntity;
import org.exoplatform.timetracker.entity.FeatureEntity;
import org.exoplatform.timetracker.entity.ProjectEntity;
import org.exoplatform.timetracker.entity.SubActivityCodeEntity;
import org.exoplatform.timetracker.entity.SubTypeEntity;
import org.exoplatform.timetracker.entity.TypeEntity;

@Entity(name="ActivityEntity")
@ExoEntity
@Table(name="ADDONS_TT_ACTIVITY")
@NamedQueries(value={@NamedQuery(name="ActivityEntity.getActivities", query="SELECT activity FROM ActivityEntity activity ORDER BY activity.label")})
public class ActivityEntity {
    @Id
    @SequenceGenerator(name="SEQ_PROJECT_ID", sequenceName="SEQ_PROJECT_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_PROJECT_ID")
    @Column(name="ID")
    private Long id;
    @Column(name="ACTIVITY_LABEL")
    private String label;
    @ManyToOne
    @JoinColumn(name="PROJECT_ID")
    private ProjectEntity projectEntity;
    @ManyToOne
    @JoinColumn(name="FEATURE_ID")
    private FeatureEntity featureEntity;
    @ManyToOne
    @JoinColumn(name="ACTIVITY_CODE_ID")
    private ActivityCodeEntity activityCodeEntity;
    @ManyToOne
    @JoinColumn(name="SUB_ACTIVITY_CODE_ID")
    private SubActivityCodeEntity subActivityCodeEntity;
    @ManyToOne
    @JoinColumn(name="TYPE_ID")
    private TypeEntity typeEntity;
    @ManyToOne
    @JoinColumn(name="SUB_TYPE_ID")
    private SubTypeEntity subTypeEntity;

    public ActivityEntity() {
    }

    public ActivityEntity(Long id, String label, ProjectEntity projectEntity, ActivityCodeEntity activityCodeEntity, SubActivityCodeEntity subActivityCodeEntity, TypeEntity typeEntity, SubTypeEntity subTypeEntity, FeatureEntity featureEntity) {
        this.id = id;
        this.label = label;
        this.projectEntity = projectEntity;
        this.activityCodeEntity = activityCodeEntity;
        this.subActivityCodeEntity = subActivityCodeEntity;
        this.typeEntity = typeEntity;
        this.subTypeEntity = subTypeEntity;
        this.featureEntity = featureEntity;
    }

    public Long getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public ProjectEntity getProjectEntity() {
        return this.projectEntity;
    }

    public FeatureEntity getFeatureEntity() {
        return this.featureEntity;
    }

    public ActivityCodeEntity getActivityCodeEntity() {
        return this.activityCodeEntity;
    }

    public SubActivityCodeEntity getSubActivityCodeEntity() {
        return this.subActivityCodeEntity;
    }

    public TypeEntity getTypeEntity() {
        return this.typeEntity;
    }

    public SubTypeEntity getSubTypeEntity() {
        return this.subTypeEntity;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setProjectEntity(ProjectEntity projectEntity) {
        this.projectEntity = projectEntity;
    }

    public void setFeatureEntity(FeatureEntity featureEntity) {
        this.featureEntity = featureEntity;
    }

    public void setActivityCodeEntity(ActivityCodeEntity activityCodeEntity) {
        this.activityCodeEntity = activityCodeEntity;
    }

    public void setSubActivityCodeEntity(SubActivityCodeEntity subActivityCodeEntity) {
        this.subActivityCodeEntity = subActivityCodeEntity;
    }

    public void setTypeEntity(TypeEntity typeEntity) {
        this.typeEntity = typeEntity;
    }

    public void setSubTypeEntity(SubTypeEntity subTypeEntity) {
        this.subTypeEntity = subTypeEntity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivityEntity)) {
            return false;
        }
        ActivityEntity other = (ActivityEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        ProjectEntity this$projectEntity = this.getProjectEntity();
        ProjectEntity other$projectEntity = other.getProjectEntity();
        if (this$projectEntity == null ? other$projectEntity != null : !((Object)this$projectEntity).equals(other$projectEntity)) {
            return false;
        }
        FeatureEntity this$featureEntity = this.getFeatureEntity();
        FeatureEntity other$featureEntity = other.getFeatureEntity();
        if (this$featureEntity == null ? other$featureEntity != null : !((Object)this$featureEntity).equals(other$featureEntity)) {
            return false;
        }
        ActivityCodeEntity this$activityCodeEntity = this.getActivityCodeEntity();
        ActivityCodeEntity other$activityCodeEntity = other.getActivityCodeEntity();
        if (this$activityCodeEntity == null ? other$activityCodeEntity != null : !((Object)this$activityCodeEntity).equals(other$activityCodeEntity)) {
            return false;
        }
        SubActivityCodeEntity this$subActivityCodeEntity = this.getSubActivityCodeEntity();
        SubActivityCodeEntity other$subActivityCodeEntity = other.getSubActivityCodeEntity();
        if (this$subActivityCodeEntity == null ? other$subActivityCodeEntity != null : !((Object)this$subActivityCodeEntity).equals(other$subActivityCodeEntity)) {
            return false;
        }
        TypeEntity this$typeEntity = this.getTypeEntity();
        TypeEntity other$typeEntity = other.getTypeEntity();
        if (this$typeEntity == null ? other$typeEntity != null : !((Object)this$typeEntity).equals(other$typeEntity)) {
            return false;
        }
        SubTypeEntity this$subTypeEntity = this.getSubTypeEntity();
        SubTypeEntity other$subTypeEntity = other.getSubTypeEntity();
        return !(this$subTypeEntity == null ? other$subTypeEntity != null : !((Object)this$subTypeEntity).equals(other$subTypeEntity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivityEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        ProjectEntity $projectEntity = this.getProjectEntity();
        result = result * 59 + ($projectEntity == null ? 43 : ((Object)$projectEntity).hashCode());
        FeatureEntity $featureEntity = this.getFeatureEntity();
        result = result * 59 + ($featureEntity == null ? 43 : ((Object)$featureEntity).hashCode());
        ActivityCodeEntity $activityCodeEntity = this.getActivityCodeEntity();
        result = result * 59 + ($activityCodeEntity == null ? 43 : ((Object)$activityCodeEntity).hashCode());
        SubActivityCodeEntity $subActivityCodeEntity = this.getSubActivityCodeEntity();
        result = result * 59 + ($subActivityCodeEntity == null ? 43 : ((Object)$subActivityCodeEntity).hashCode());
        TypeEntity $typeEntity = this.getTypeEntity();
        result = result * 59 + ($typeEntity == null ? 43 : ((Object)$typeEntity).hashCode());
        SubTypeEntity $subTypeEntity = this.getSubTypeEntity();
        result = result * 59 + ($subTypeEntity == null ? 43 : ((Object)$subTypeEntity).hashCode());
        return result;
    }

    public String toString() {
        return "ActivityEntity(id=" + this.getId() + ", label=" + this.getLabel() + ", projectEntity=" + this.getProjectEntity() + ", featureEntity=" + this.getFeatureEntity() + ", activityCodeEntity=" + this.getActivityCodeEntity() + ", subActivityCodeEntity=" + this.getSubActivityCodeEntity() + ", typeEntity=" + this.getTypeEntity() + ", subTypeEntity=" + this.getSubTypeEntity() + ")";
    }
}

