/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.timetracker.dto.Team;
import org.exoplatform.timetracker.dto.TeamMember;
import org.exoplatform.timetracker.storage.TeamStorage;

public class TeamService {
    private static Map<String, List<Team>> teams = new HashMap<String, List<Team>>();
    private final TeamStorage teamStorage;

    public TeamService(TeamStorage teamStorage) {
        this.teamStorage = teamStorage;
    }

    public Team createTeam(Team team) throws Exception {
        if (team == null) {
            throw new IllegalArgumentException("Team is mandatory");
        }
        return this.teamStorage.createTeam(team);
    }

    public Team updateTeam(Team team) throws Exception {
        if (team == null) {
            throw new IllegalArgumentException("Team is mandatory");
        }
        String teamId = team.getId();
        if (teamId == null) {
            throw new EntityNotFoundException("Team with null id wasn't found");
        }
        Team storedProject = this.teamStorage.getTeamById(teamId);
        if (storedProject == null) {
            throw new EntityNotFoundException("Team with id " + teamId + " wasn't found");
        }
        return this.teamStorage.updateTeam(team);
    }

    public void deleteTeam(String teamId) throws Exception {
        Team storedTeam = this.teamStorage.getTeamById(teamId);
        if (storedTeam == null) {
            throw new EntityNotFoundException("Team with id " + teamId + " not found");
        }
        this.teamStorage.deleteAllTeamMembersByTeam(teamId);
        this.teamStorage.deleteTeam(teamId);
    }

    public List<Team> getTeamsList(String userName) throws Exception {
        if (teams.get(userName) != null) {
            return teams.get(userName);
        }
        List<Team> teamList = this.teamStorage.getTeamsByUser(userName);
        teams.put(userName, teamList);
        return teamList;
    }

    public List<TeamMember> getMembersList(String teamID) throws Exception {
        return this.teamStorage.getMembersByTeam(teamID);
    }

    public List<TeamMember> getEmployeesList(String userName) throws Exception {
        return this.teamStorage.getEmployees(userName);
    }

    public List<Team> getTeams() throws Exception {
        return this.teamStorage.getTeams();
    }

    public void createTeamMember(TeamMember teamMember) throws Exception {
        if (teamMember == null) {
            throw new IllegalArgumentException("TeamMember is mandatory");
        }
        if (this.teamStorage.getMemberByTeamUserAndRole(teamMember.getTeam().getId(), teamMember.getUserName(), teamMember.getRole()) != null) {
            throw new EntityExistsException("TeamMember Already exist");
        }
        this.teamStorage.createTeamMember(teamMember);
        if (teams.get(teamMember.getUserName()) != null) {
            List<Team> teamList = this.teamStorage.getTeamsByUser(teamMember.getUserName());
            teams.put(teamMember.getUserName(), teamList);
        }
    }

    public void deleteTeamMember(String teamMemberId) throws Exception {
        TeamMember storedTeamMember = this.teamStorage.getTeamMemberById(teamMemberId);
        if (storedTeamMember == null) {
            throw new EntityNotFoundException("TeamMember with id " + teamMemberId + " not found");
        }
        this.teamStorage.deleteTeamMember(teamMemberId);
    }
}

