/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.trashCleaner;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TrashCleanerJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(TrashCleanerJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String timeLimit = System.getProperty("trashcleaner.lifetime");
        if (timeLimit == null) {
            timeLimit = "30";
        }
        LOG.info((Object)("Start TrashCleanerJob, delete nodes in trash older than " + timeLimit + " days."));
        TrashService trashService = (TrashService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(TrashService.class);
        int deletedNode = 0;
        Node trashNode = trashService.getTrashHomeNode();
        try {
            if (trashNode.hasNodes()) {
                NodeIterator childNodes = trashNode.getNodes();
                long size = childNodes.getSize();
                int current = 1;
                while (childNodes.hasNext()) {
                    Node currentNode = (Node)childNodes.next();
                    try {
                        if (current % 20 == 0) {
                            LOG.info((Object)("Checking node " + currentNode.getName() + " node from Trash (" + current + "/" + size + ")"));
                        }
                        if (currentNode.getName().equals("exo:actions") && currentNode.hasNode("trashFolder")) continue;
                        if (currentNode.hasProperty("exo:lastModifiedDate")) {
                            long dateCreated = currentNode.getProperty("exo:lastModifiedDate").getDate().getTimeInMillis();
                            if (Calendar.getInstance().getTimeInMillis() - dateCreated > Long.parseLong(timeLimit) * 24L * 60L * 60L * 1000L && currentNode.isNodeType("exo:restoreLocation")) {
                                this.deleteNode(currentNode, trashService);
                                ++deletedNode;
                            }
                        } else {
                            this.deleteNode(currentNode, trashService);
                            ++deletedNode;
                        }
                        ++current;
                    }
                    catch (Exception ex) {
                        LOG.info((Object)("Error while removing " + currentNode.getName() + " node from Trash"), (Throwable)ex);
                    }
                }
            }
        }
        catch (RepositoryException ex) {
            LOG.info((Object)"Failed to get child nodes", (Throwable)ex);
        }
        LOG.info((Object)("Empty Trash folder successfully! " + deletedNode + " nodes deleted"));
    }

    private static void removeMixins(Node node) throws Exception {
        NodeType[] mixins;
        for (NodeType nodeType : mixins = node.getMixinNodeTypes()) {
            node.removeMixin(nodeType.getName());
        }
    }

    public void deleteNode(Node node, TrashService trashService) throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(TaxonomyService.class);
        ActionServiceContainer actionService = (ActionServiceContainer)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActionServiceContainer.class);
        ThumbnailService thumbnailService = (ThumbnailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ThumbnailService.class);
        RepositoryService repoService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
        Session session = node.getSession();
        Node parentNode = node.getParent();
        try {
            try {
                this.removeReferences(node);
            }
            catch (Exception ex) {
                LOG.info((Object)"An error occurs while removing relations", (Throwable)ex);
            }
            try {
                actionService.removeAction(node, repoService.getCurrentRepository().getConfiguration().getName());
            }
            catch (Exception ex) {
                LOG.info((Object)"An error occurs while removing actions ", (Throwable)ex);
            }
            try {
                thumbnailService.processRemoveThumbnail(node);
            }
            catch (Exception ex) {
                LOG.info((Object)"An error occurs while removing thumbnail ", (Throwable)ex);
            }
            try {
                if (PermissionUtil.canRemoveNode((Node)node) && node.isNodeType("exo:auditable")) {
                    this.removeAuditForNode(node, repoService.getCurrentRepository());
                }
            }
            catch (Exception ex) {
                LOG.info((Object)"An error occurs while removing audit ", (Throwable)ex);
            }
            node.remove();
            parentNode.getSession().save();
        }
        catch (ReferentialIntegrityException ref) {
            session.refresh(false);
        }
        catch (ConstraintViolationException cons) {
            session.refresh(false);
        }
        catch (Exception ex) {
            LOG.info((Object)("Error while removing " + node.getName() + " node from Trash"), (Throwable)ex);
        }
    }

    private void removeReferences(Node node) throws Exception {
        RelationsService relationService = (RelationsService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RelationsService.class);
        PropertyIterator iter = node.getReferences();
        while (iter.hasNext()) {
            Node refNode = iter.nextProperty().getParent();
            relationService.removeRelation(refNode, node.getPath());
        }
        NodeIterator children = node.getNodes();
        while (children.hasNext()) {
            Node child = children.nextNode();
            this.removeReferences(child);
        }
    }

    private void removeAuditForNode(Node node, ManageableRepository repository) throws Exception {
        Session session = SessionProvider.createSystemProvider().getSession(node.getSession().getWorkspace().getName(), repository);
        if (session.getRootNode().hasNode("exo:audit") && session.getRootNode().getNode("exo:audit").hasNode(node.getUUID())) {
            session.getRootNode().getNode("exo:audit").getNode(node.getUUID()).remove();
            session.save();
        }
    }
}

