/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upgrade;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.upgrade.CleanFavoriteApplications;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class CleanFavoriteApplicationsTest {
    @Mock
    private EntityManagerService entityManagerService;
    @Mock
    private EntityManager entityManager;
    @Mock
    private Query query;
    private CleanFavoriteApplications cleanFavoriteApplications;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        InitParams initParams = new InitParams();
        this.cleanFavoriteApplications = new CleanFavoriteApplications(initParams, this.entityManagerService);
        Mockito.when((Object)this.entityManagerService.getEntityManager()).thenReturn((Object)this.entityManager);
    }

    @Test
    public void processUpgradeCleanDuplicatedFavoriteApps() {
        List<Object[]> results = List.of(new Object[]{1L, 100L, "user1"}, new Object[]{2L, 100L, "user1"}, new Object[]{3L, 101L, "test"}, new Object[]{4L, 101L, "test"});
        Mockito.when((Object)this.entityManager.createNativeQuery(ArgumentMatchers.anyString())).thenReturn((Object)this.query);
        Mockito.when((Object)this.query.getResultList()).thenReturn(results);
        Mockito.when((Object)this.query.executeUpdate()).thenReturn((Object)2);
        this.cleanFavoriteApplications.processUpgrade("v1", "v1");
        ((EntityManager)Mockito.verify((Object)this.entityManager, (VerificationMode)Mockito.times((int)3))).createNativeQuery(ArgumentMatchers.anyString());
        ((Query)Mockito.verify((Object)this.query, (VerificationMode)Mockito.times((int)2))).executeUpdate();
        ((EntityManagerService)Mockito.verify((Object)this.entityManagerService, (VerificationMode)Mockito.times((int)1))).getEntityManager();
    }

    @Test
    public void processUpgradeNoDuplicatedFavoriteApps() {
        List<Object[]> results = List.of(new Object[]{1L, 100L, "user1"}, new Object[]{2L, 101L, "test"});
        Mockito.when((Object)this.entityManager.createNativeQuery(ArgumentMatchers.anyString())).thenReturn((Object)this.query);
        Mockito.when((Object)this.query.getResultList()).thenReturn(results);
        this.cleanFavoriteApplications.processUpgrade("v1", "v1");
        ((Query)Mockito.verify((Object)this.query, (VerificationMode)Mockito.never())).executeUpdate();
    }
}

