/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.upgrade;

import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.application.upgrade.AppRegistryUpgradePlugin;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.service.DataStorage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.application-registry-configuration-local.xml")})
public class AppRegistryUpgradePluginTest
extends AbstractKernelTest {
    protected PortalContainer container;
    protected ApplicationRegistryService applicationRegistryService;
    protected DataStorage dataStorage;
    protected EntityManagerService entityManagerService;

    @Before
    public void setUp() {
        this.container = PortalContainer.getInstance();
        this.applicationRegistryService = (ApplicationRegistryService)CommonsUtils.getService(ApplicationRegistryService.class);
        this.dataStorage = (DataStorage)CommonsUtils.getService(DataStorage.class);
        this.entityManagerService = (EntityManagerService)CommonsUtils.getService(EntityManagerService.class);
        this.begin();
    }

    @After
    public void tearDown() {
        this.end();
    }

    @Test
    public void testAppsMigration() throws WikiException {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("old.content.id");
        valueParam.setValue("oldContentId");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("new.description");
        valueParam.setValue("newDescription");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("new.display.name");
        valueParam.setValue("newDisplayName");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("new.app.name");
        valueParam.setValue("newAppName");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("new.content.id");
        valueParam.setValue("newContentId");
        initParams.addParameter((Parameter)valueParam);
        String officeCategoryName = "Office";
        ApplicationCategory officeCategory = this.createAppCategory(officeCategoryName, "None");
        this.applicationRegistryService.save(officeCategory);
        Application msApp = this.createApplication();
        this.applicationRegistryService.save(officeCategory, msApp);
        try {
            List apps = this.applicationRegistryService.getApplications(officeCategory, new ApplicationType[0]);
            AppRegistryUpgradePluginTest.assertEquals((int)apps.size(), (int)1);
            AppRegistryUpgradePluginTest.assertEquals((String)((Application)apps.get(0)).getContentId(), (String)"oldContentId");
        }
        catch (Exception e) {
            AppRegistryUpgradePluginTest.fail();
        }
        AppRegistryUpgradePlugin wikiAppRegistryUpgradePlugin = new AppRegistryUpgradePlugin(this.container, this.entityManagerService, initParams);
        wikiAppRegistryUpgradePlugin.processUpgrade(null, null);
        try {
            List apps = this.applicationRegistryService.getApplications(officeCategory, new ApplicationType[0]);
            AppRegistryUpgradePluginTest.assertEquals((String)((Application)apps.get(0)).getContentId(), (String)"newContentId");
        }
        catch (Exception e) {
            AppRegistryUpgradePluginTest.fail();
        }
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }

    private ApplicationCategory createAppCategory(String categoryName, String categoryDes) {
        ApplicationCategory category = new ApplicationCategory();
        category.setName(categoryName);
        category.setDisplayName(categoryName);
        category.setDescription(categoryDes);
        return category;
    }

    private Application createApplication() {
        Application app = new Application();
        app.setContentId("oldContentId");
        app.setApplicationName("appName");
        app.setDisplayName("appName");
        app.setType(ApplicationType.PORTLET);
        return app;
    }
}

