/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.views;

import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.ecms.upgrade.views.SiteExplorerTemplateUpgradePlugin;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SiteExplorerTemplateUpgradePluginTest {
    private static final MockedStatic<Utils> UTILS = Mockito.mockStatic(Utils.class);
    @Mock
    NodeHierarchyCreator nodeHierarchyCreator;
    @Mock
    RepositoryService repositoryService;
    @Mock
    DMSConfiguration dmsConfiguration;
    @Mock
    DMSRepositoryConfiguration dmsRepoConfig;
    @Mock
    ManageViewService manageViewService;
    @Mock
    SessionProviderService sessionProviderService;
    @Mock
    ManageableRepository repository;
    @Mock
    RepositoryEntry repositoryEntry;
    @Mock
    SessionProvider sessionProvider;
    @Mock
    ExtendedSession session;
    @Mock
    NodeIterator nodeIterator;

    @AfterClass
    public static void afterRunBare() throws Exception {
        UTILS.close();
    }

    @Test
    public void testSiteExplorerTemplateMigration() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.ecms");
        initParams.addParameter((Parameter)valueParam);
        HashSet<String> configuredtemplates = new HashSet<String>(Arrays.asList("template1", "template2", "template3"));
        Mockito.when((Object)this.manageViewService.getConfiguredTemplates()).thenReturn(configuredtemplates);
        Mockito.when((Object)this.dmsConfiguration.getConfig()).thenReturn((Object)this.dmsRepoConfig);
        Mockito.when((Object)this.dmsRepoConfig.getSystemWorkspace()).thenReturn((Object)"dms-system");
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repository.getSystemSession(ArgumentMatchers.anyString())).thenReturn((Object)this.session);
        Mockito.when((Object)this.nodeHierarchyCreator.getJcrPath(ArgumentMatchers.anyString())).thenReturn((Object)"ecmExplorerTemplates");
        Node ecmExplorerViewNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)((Node)this.session.getItem(ArgumentMatchers.anyString()))).thenReturn((Object)ecmExplorerViewNode);
        Mockito.when((Object)ecmExplorerViewNode.getNodes()).thenReturn((Object)this.nodeIterator);
        Mockito.when((Object)this.nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Node viewNode2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)viewNode2.getName()).thenReturn((Object)"template2");
        Node viewNode4 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)viewNode4.getName()).thenReturn((Object)"template4");
        Node viewNode3 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)viewNode3.getName()).thenReturn((Object)"template3");
        Mockito.when((Object)this.nodeIterator.nextNode()).thenReturn((Object)viewNode2).thenReturn((Object)viewNode4).thenReturn((Object)viewNode3);
        SiteExplorerTemplateUpgradePlugin siteExplorerTemplateUpgradePlugin = new SiteExplorerTemplateUpgradePlugin(initParams, this.nodeHierarchyCreator, this.repositoryService, this.dmsConfiguration, this.manageViewService);
        siteExplorerTemplateUpgradePlugin.processUpgrade(null, null);
        ((Node)Mockito.verify((Object)ecmExplorerViewNode, (VerificationMode)Mockito.times((int)2))).save();
    }
}

