/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.templates;

import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Workspace;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.ecms.upgrade.templates.NodeTypeTemplateUpgradePlugin;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplateServiceImpl;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NodeTypeTemplateUpgradePluginTest {
    private static final MockedStatic<Utils> UTILS = Mockito.mockStatic(Utils.class);
    @Mock
    TemplateServiceImpl templateService;
    @Mock
    ProductInformations productInformations;
    @Mock
    ExtendedSession session;
    @Mock
    NodeIterator nodeIterator;

    @AfterClass
    public static void afterRunBare() throws Exception {
        UTILS.close();
    }

    @Test
    public void testNodeTypeTemplateMigration() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.ecms");
        initParams.addParameter((Parameter)valueParam);
        Node templateHomeNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.templateService.getTemplatesHome((SessionProvider)ArgumentMatchers.any())).thenReturn((Object)templateHomeNode);
        HashSet<String> configuredTemplates = new HashSet<String>();
        configuredTemplates.add("template2");
        configuredTemplates.add("template3");
        configuredTemplates.add("template4");
        Mockito.when((Object)this.templateService.getAllConfiguredNodeTypes()).thenReturn(configuredTemplates);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)templateHomeNode.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)templateHomeNode.getNodes()).thenReturn((Object)this.nodeIterator);
        Mockito.when((Object)this.nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Node templateNode1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)templateNode1.getName()).thenReturn((Object)"template2");
        Node templateNode2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)templateNode2.getName()).thenReturn((Object)"template4");
        Node templateNode3 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)templateNode3.getName()).thenReturn((Object)"template3");
        Mockito.when((Object)this.nodeIterator.nextNode()).thenReturn((Object)templateNode1).thenReturn((Object)templateNode2).thenReturn((Object)templateNode3);
        HashSet<String> modifiedTemplateList = new HashSet<String>();
        modifiedTemplateList.add("template2");
        UTILS.when(() -> Utils.getAllEditedConfiguredData((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (boolean)ArgumentMatchers.anyBoolean())).thenReturn(modifiedTemplateList);
        NodeTypeTemplateUpgradePlugin nodeTypeTemplateUpgradePlugin = new NodeTypeTemplateUpgradePlugin((TemplateService)this.templateService, this.productInformations, initParams);
        nodeTypeTemplateUpgradePlugin.processUpgrade(null, null);
        ((Node)Mockito.verify((Object)templateHomeNode, (VerificationMode)Mockito.times((int)3))).save();
        ((TemplateServiceImpl)Mockito.verify((Object)this.templateService, (VerificationMode)Mockito.times((int)1))).start();
    }
}

