/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.migration.NavigationNotesMigration;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.jdbc.entity.NodeEntity;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.NodeDAO;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.Node;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.services.cache.CacheService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/config/conf/configuration.xml")})
public class NavigationNodesMigrationTest
extends AbstractKernelTest {
    protected PortalContainer container;
    protected NavigationService navigationService;
    protected LayoutService layoutService;
    protected EntityManagerService entityManagerService;
    protected CacheService cacheService;
    protected NavigationContext nav;
    protected String oldName = "oldName";
    protected String newName = "newName";
    protected String newLabel = "newLabel";

    @Before
    public void setUp() throws Exception {
        this.container = PortalContainer.getInstance();
        this.navigationService = (NavigationService)this.container.getComponentInstanceOfType(NavigationService.class);
        this.layoutService = (LayoutService)this.container.getComponentInstanceOfType(LayoutService.class);
        this.entityManagerService = (EntityManagerService)this.container.getComponentInstanceOfType(EntityManagerService.class);
        this.cacheService = (CacheService)this.container.getComponentInstanceOfType(CacheService.class);
        this.begin();
        this.injectData();
    }

    @After
    public void tearDown() {
        this.purgeData();
        this.end();
    }

    @Test
    public void testNodeMigration() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("old.nav.name");
        valueParam.setValue(this.oldName);
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("new.nav.name");
        valueParam.setValue(this.newName);
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("new.nav.label");
        valueParam.setValue(this.newLabel);
        initParams.addParameter((Parameter)valueParam);
        NodeContext node = this.navigationService.loadNode(Node.MODEL, this.nav, Scope.ALL, null);
        NodeContext page = node.get(this.oldName);
        NavigationNodesMigrationTest.assertNotNull((Object)page);
        NavigationNodesMigrationTest.assertEquals((String)this.oldName, (String)page.getName());
        NavigationNotesMigration noteMigration = new NavigationNotesMigration(this.container, this.entityManagerService, this.cacheService, initParams);
        NavigationNodesMigrationTest.assertEquals((int)0, (int)noteMigration.getNodesUpdatedCount());
        noteMigration.processUpgrade(null, null);
        NavigationNodesMigrationTest.assertEquals((int)1, (int)noteMigration.getNodesUpdatedCount());
        NavigationNodesMigrationTest.assertTrue((boolean)noteMigration.shouldProceedToUpgrade("v1", "v1", new UpgradePluginExecutionContext("v1;0")));
        this.end();
        this.begin();
        NodeDAO nodeDAO = (NodeDAO)CommonsUtils.getService(NodeDAO.class);
        NodeEntity newPage = (NodeEntity)nodeDAO.find((Serializable)Long.valueOf(page.getId()));
        NavigationNodesMigrationTest.assertNotNull((Object)newPage);
        NavigationNodesMigrationTest.assertEquals((String)this.newName, (String)newPage.getName());
        NavigationNodesMigrationTest.assertEquals((String)this.newLabel, (String)newPage.getLabel());
    }

    protected void injectData() throws Exception {
        this.createSite(SiteType.PORTAL, "new_node");
        this.nav = this.navigationService.loadNavigation(SiteKey.portal((String)"new_node"));
        NodeContext node = this.navigationService.loadNode(Node.MODEL, this.nav, Scope.ALL, null);
        node.add(Integer.valueOf(0), this.oldName);
        this.navigationService.saveNode(node, null);
    }

    protected void purgeData() {
        this.navigationService.destroyNavigation(this.nav);
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }

    protected void createSite(SiteType type, String siteName) throws Exception {
        ContainerData container = new ContainerData(null, "testcontainer_" + siteName, "", "", "", "", "", "", "", "", "", "", "", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        PortalData portal = new PortalData(null, siteName, type.getName(), null, null, null, new ArrayList(), null, null, null, container, true, 5, 0L);
        this.layoutService.create(new PortalConfig(portal));
        NavigationContext nav = new NavigationContext(type.key(siteName), new NavigationState(Integer.valueOf(1)));
        this.navigationService.saveNavigation(nav);
    }
}

