/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.jcr;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.upgrade.jcr.PublishedNewsImagesPermissionsUpgradePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class PublishedNewsImagesPermissionsUpgradePluginTest {
    @Mock
    RepositoryService repositoryService;
    @Mock
    ManageableRepository repository;
    @Mock
    RepositoryEntry repositoryEntry;
    @Mock
    Session session;
    @Mock
    SessionProviderService sessionProviderService;
    @Mock
    SessionProvider sessionProvider;
    private static final MockedStatic<PortalContainer> PORTAL_CONTAINER = Mockito.mockStatic(PortalContainer.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        PORTAL_CONTAINER.close();
    }

    @Test
    public void publishedNewsImagesPermissionsUpgradePluginTest() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.news");
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(Mockito.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.sessionProvider.getSession((String)Mockito.any(), (ManageableRepository)Mockito.any())).thenReturn((Object)this.session);
        QueryManager qm = (QueryManager)Mockito.mock(QueryManager.class);
        Workspace workSpace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workSpace);
        Mockito.when((Object)workSpace.getQueryManager()).thenReturn((Object)qm);
        Query query = (Query)Mockito.mock(QueryImpl.class);
        Mockito.when((Object)qm.createQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)query);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Node newsNode = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)newsNode);
        Mockito.when((Object)newsNode.hasProperty("exo:body")).thenReturn((Object)true);
        Mockito.when((Object)newsNode.getProperty("exo:body")).thenReturn((Object)property);
        Mockito.when((Object)property.getString()).thenReturn((Object)"news body with image src=\"/portal/rest/images/repository/collaboration/123\"");
        ExtendedNode imageNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.when((Object)this.session.getNodeByUUID("123")).thenReturn((Object)imageNode);
        Mockito.when((Object)imageNode.canAddMixin("exo:privilegeable")).thenReturn((Object)true);
        AccessControlList accessControlList = (AccessControlList)Mockito.mock(AccessControlList.class);
        Mockito.when((Object)imageNode.getACL()).thenReturn((Object)accessControlList);
        Mockito.when((Object)accessControlList.getPermissionEntries()).thenReturn(new ArrayList());
        PublishedNewsImagesPermissionsUpgradePlugin publishedNewsImagesPermissionsUpgradePlugin = new PublishedNewsImagesPermissionsUpgradePlugin(initParams, this.repositoryService, this.sessionProviderService);
        publishedNewsImagesPermissionsUpgradePlugin.processUpgrade(null, null);
        ((ExtendedNode)Mockito.verify((Object)imageNode, (VerificationMode)Mockito.times((int)1))).setPermission("*:/platform/users", new String[]{"read"});
        ((ExtendedNode)Mockito.verify((Object)imageNode, (VerificationMode)Mockito.times((int)1))).save();
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)property.getString()).thenReturn((Object)"news body with image src=\"https://exoplatform.com/portal/rest/jcr/repository/collaboration/Groups/spaces/test/testimage\"");
        String currentDomainName = "https://exoplatform.com";
        String currentPortalContainerName = "portal";
        String restContextName = "rest";
        COMMONS_UTILS.when(() -> CommonsUtils.getRestContextName()).thenReturn((Object)restContextName);
        PORTAL_CONTAINER.when(() -> PortalContainer.getCurrentPortalContainerName()).thenReturn((Object)currentPortalContainerName);
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentDomain()).thenReturn((Object)currentDomainName);
        ExtendedNode existingUploadImageNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.when((Object)existingUploadImageNode.canAddMixin("exo:privilegeable")).thenReturn((Object)true);
        Mockito.when((Object)this.session.getItem((String)Mockito.nullable(String.class))).thenReturn((Object)existingUploadImageNode);
        Mockito.when((Object)existingUploadImageNode.getACL()).thenReturn((Object)accessControlList);
        publishedNewsImagesPermissionsUpgradePlugin.processUpgrade(null, null);
        ((ExtendedNode)Mockito.verify((Object)existingUploadImageNode, (VerificationMode)Mockito.times((int)1))).setPermission("*:/platform/users", new String[]{"read"});
        ((ExtendedNode)Mockito.verify((Object)existingUploadImageNode, (VerificationMode)Mockito.times((int)1))).save();
    }
}

