/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.upgrade.RemoveNewsRootNodeUpgradePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoveNewsRootNodeUpgradePluginTest {
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SessionProviderService sessionProviderService;
    @Mock
    SessionProvider sessionProvider;
    @Mock
    Session session;
    @Mock
    ManageableRepository repository;
    @Mock
    RepositoryEntry repositoryEntry;
    public static final String APPLICATION_DATA_PATH = "/Application Data";
    public static final String NEWS_NODES_FOLDER = "News";
    public static final String PUBLISHED_NEWS_NODES_FOLDER = "Pinned";

    @Test
    public void testRemoveNewsRootNode() throws RepositoryException {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        RemoveNewsRootNodeUpgradePlugin removeNewsRootNodeUpgradePlugin = new RemoveNewsRootNodeUpgradePlugin(initParams, this.repositoryService, this.sessionProviderService);
        Node applicationDataNode = (Node)Mockito.mock(Node.class);
        Node newsRootNode = (Node)Mockito.mock(Node.class);
        Node newsPinnedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(Mockito.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)Mockito.any(), (ManageableRepository)Mockito.any())).thenReturn((Object)this.session);
        Mockito.when((Object)((Node)this.session.getItem(APPLICATION_DATA_PATH))).thenReturn((Object)applicationDataNode);
        Mockito.when((Object)applicationDataNode.hasNode(NEWS_NODES_FOLDER)).thenReturn((Object)false);
        ((Node)Mockito.doNothing().when((Object)newsRootNode)).save();
        ((Node)Mockito.doNothing().when((Object)applicationDataNode)).save();
        ((Node)Mockito.doNothing().when((Object)newsPinnedNode)).remove();
        removeNewsRootNodeUpgradePlugin.processUpgrade("v1", "v2");
        ((Node)Mockito.verify((Object)applicationDataNode, (VerificationMode)Mockito.times((int)0))).getNode(Mockito.anyString());
        ((Node)Mockito.verify((Object)applicationDataNode, (VerificationMode)Mockito.times((int)0))).save();
        ((Node)Mockito.verify((Object)newsRootNode, (VerificationMode)Mockito.times((int)0))).remove();
        Mockito.when((Object)applicationDataNode.hasNode(NEWS_NODES_FOLDER)).thenReturn((Object)true);
        Mockito.when((Object)applicationDataNode.getNode(NEWS_NODES_FOLDER)).thenReturn((Object)newsRootNode);
        Mockito.when((Object)newsRootNode.hasNode(PUBLISHED_NEWS_NODES_FOLDER)).thenReturn((Object)false);
        removeNewsRootNodeUpgradePlugin.processUpgrade("v1", "v2");
        ((Node)Mockito.verify((Object)applicationDataNode, (VerificationMode)Mockito.times((int)0))).save();
        ((Node)Mockito.verify((Object)newsRootNode, (VerificationMode)Mockito.times((int)0))).save();
        Mockito.when((Object)newsRootNode.hasNode(PUBLISHED_NEWS_NODES_FOLDER)).thenReturn((Object)true);
        Mockito.when((Object)newsRootNode.getNode(PUBLISHED_NEWS_NODES_FOLDER)).thenReturn((Object)newsPinnedNode);
        removeNewsRootNodeUpgradePlugin.processUpgrade("v1", "v2");
        ((Node)Mockito.verify((Object)applicationDataNode, (VerificationMode)Mockito.times((int)1))).save();
        ((Node)Mockito.verify((Object)newsRootNode, (VerificationMode)Mockito.times((int)1))).save();
        ((Node)Mockito.verify((Object)newsPinnedNode, (VerificationMode)Mockito.times((int)1))).remove();
    }
}

