/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.activities;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.upgrade.activities.SharedNewsActivitiesUpgradePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SharedNewsActivitiesUpgradePluginTest {
    @Mock
    RepositoryService repositoryService;
    @Mock
    ActivityManager activityManager;
    @Mock
    ManageableRepository repository;
    @Mock
    RepositoryEntry repositoryEntry;
    @Mock
    ExtendedSession session;
    @Mock
    ExoSocialActivity sharedNewsActivity;

    @Test
    public void testOldSharedNewsActivitiesMigration() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.addons.news");
        initParams.addParameter((Parameter)valueParam);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repository.getSystemSession(ArgumentMatchers.anyString())).thenReturn((Object)this.session);
        QueryManager qm = (QueryManager)Mockito.mock(QueryManager.class);
        Workspace workSpace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workSpace);
        Mockito.when((Object)workSpace.getQueryManager()).thenReturn((Object)qm);
        Query query = (Query)Mockito.mock(QueryImpl.class);
        Mockito.when((Object)qm.createQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)query);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Node newsNode = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)newsNode.getProperty("exo:activities")).thenReturn((Object)property);
        Mockito.when((Object)property.getString()).thenReturn((Object)"1:1;1:2;2:3", (Object[])new String[]{"2:4;1:5;2:6"});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)newsNode);
        Mockito.when((Object)this.activityManager.getActivity(ArgumentMatchers.anyString())).thenReturn((Object)this.sharedNewsActivity);
        SharedNewsActivitiesUpgradePlugin sharedNewsActivitiesUpgradePlugin = new SharedNewsActivitiesUpgradePlugin(initParams, this.repositoryService, this.activityManager);
        sharedNewsActivitiesUpgradePlugin.processUpgrade(null, null);
        Assert.assertEquals((long)4L, (long)sharedNewsActivitiesUpgradePlugin.getSharedNewsActivitiesCount());
    }
}

