/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.upgrade.jcr.NewsJcrNodePermissionsUpgradePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsJcrNodePermissionsUpgradePluginTest {
    @Mock
    NodeHierarchyCreator nodeHierarchyCreator;
    @Mock
    RepositoryService repositoryService;
    @Mock
    SessionProviderService sessionProviderService;
    @Mock
    ManageableRepository repository;
    @Mock
    RepositoryEntry repositoryEntry;
    @Mock
    SessionProvider sessionProvider;
    @Mock
    Session session;
    @Mock
    NodeIterator nodeIterator;

    @Test
    public void testNewsJcrNodeMigration() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.addons.news");
        initParams.addParameter((Parameter)valueParam);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Mockito.when((Object)this.nodeHierarchyCreator.getJcrPath(ArgumentMatchers.anyString())).thenReturn((Object)"groupsPath");
        Node spacesRootNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)((Node)this.session.getItem(ArgumentMatchers.anyString()))).thenReturn((Object)spacesRootNode);
        Mockito.when((Object)spacesRootNode.getNodes()).thenReturn((Object)this.nodeIterator);
        Mockito.when((Object)this.nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Node spaceNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.nodeIterator.nextNode()).thenReturn((Object)spaceNode);
        Mockito.when((Object)spaceNode.hasNode("News")).thenReturn((Object)true);
        ExtendedNode spaceNewsExtendedRootNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.when((Object)spaceNode.getNode("News")).thenReturn((Object)spaceNewsExtendedRootNode);
        spaceNewsExtendedRootNode.setPermission("*:/platform/administrators", PermissionType.ALL);
        NewsJcrNodePermissionsUpgradePlugin newsJcrNodePermissionsUpgradePlugin = new NewsJcrNodePermissionsUpgradePlugin(initParams, this.nodeHierarchyCreator, this.repositoryService, this.sessionProviderService);
        newsJcrNodePermissionsUpgradePlugin.processUpgrade(null, null);
        ((ExtendedNode)Mockito.verify((Object)spaceNewsExtendedRootNode, (VerificationMode)Mockito.times((int)2))).save();
        Assert.assertEquals((long)2L, (long)newsJcrNodePermissionsUpgradePlugin.getNewsJcrNodesUpdatedCount());
    }
}

