/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.targets;

import java.util.HashMap;
import java.util.LinkedList;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.upgrade.targets.TargetsDefaultPermissionUpgrade;
import org.exoplatform.social.core.metadata.storage.MetadataStorage;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TargetsDefaultPermissionUpgradeTest {
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<PortalContainer> PORTAL_CONTAINER = Mockito.mockStatic(PortalContainer.class);
    private static final MockedStatic<RequestLifeCycle> REQUEST_LIFECYCLE = Mockito.mockStatic(RequestLifeCycle.class);
    @Mock
    private MetadataService metadataService;
    @Mock
    private MetadataStorage metadataStorage;

    @AfterClass
    public static void afterRunBare() throws Exception {
        EXO_CONTAINER_CONTEXT.close();
        PORTAL_CONTAINER.close();
        REQUEST_LIFECYCLE.close();
    }

    @Test
    public void processUpgrade() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        MetadataType metadataType = new MetadataType(4L, "newsTarget");
        LinkedList<Metadata> newsTargets = new LinkedList<Metadata>();
        Metadata sliderNews = new Metadata();
        sliderNews.setName("sliderNews");
        sliderNews.setCreatedDate(100L);
        HashMap<String, String> sliderNewsProperties = new HashMap<String, String>();
        sliderNewsProperties.put("label", "slider news");
        sliderNews.setProperties(sliderNewsProperties);
        sliderNews.setId(1L);
        newsTargets.add(sliderNews);
        Metadata latestNews = new Metadata();
        latestNews.setName("latestNews");
        latestNews.setCreatedDate(100L);
        HashMap<String, String> latestNewsProperties = new HashMap<String, String>();
        latestNewsProperties.put("label", "latest news");
        latestNewsProperties.put("permissions", "space:1");
        latestNews.setProperties(latestNewsProperties);
        latestNews.setId(2L);
        newsTargets.add(latestNews);
        Metadata testNews = new Metadata();
        testNews.setName("testNews");
        testNews.setCreatedDate(100L);
        HashMap<String, String> testNewsProperties = new HashMap<String, String>();
        testNewsProperties.put("label", "test news");
        testNews.setProperties(testNewsProperties);
        testNews.setId(3L);
        newsTargets.add(testNews);
        Mockito.when((Object)this.metadataService.getMetadatas(metadataType.getName(), 0L)).thenReturn(newsTargets);
        TargetsDefaultPermissionUpgrade targetsDefaultPermissionUpgrade = new TargetsDefaultPermissionUpgrade(initParams, this.metadataService, this.metadataStorage);
        targetsDefaultPermissionUpgrade.processUpgrade(null, null);
        ((MetadataStorage)Mockito.verify((Object)this.metadataStorage, (VerificationMode)Mockito.times((int)2))).updateMetadata((Metadata)ArgumentMatchers.any());
        Assert.assertEquals((long)2L, (long)targetsDefaultPermissionUpgrade.getMigratedNoDefaultPermissionTargetsCount());
    }
}

