/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.upgrade.jcr.NewsArticlesViewsCountUpgrade;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsArticlesViewsCountUpgradeTest {
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SessionProviderService sessionProviderService;
    @Mock
    private ManageableRepository repository;
    @Mock
    private RepositoryEntry repositoryEntry;
    @Mock
    private SessionProvider sessionProvider;
    @Mock
    private Session session;
    @Mock
    private NodeIterator nodeIterator;
    @Mock
    private QueryManager queryManager;

    @Test
    public void testNewsArticleViewsCountUpgrade() throws RepositoryException {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        Node testNode = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        Value value = (Value)Mockito.mock(Value.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Query query = (Query)Mockito.mock(Query.class);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Mockito.when((Object)this.nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)this.queryManager.createQuery(ArgumentMatchers.anyString(), (String)ArgumentMatchers.any())).thenReturn((Object)query);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)this.nodeIterator);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)this.queryManager);
        Mockito.when((Object)this.nodeIterator.nextNode()).thenReturn((Object)testNode);
        Mockito.when((Object)testNode.hasProperty("exo:viewsCount")).thenReturn((Object)true);
        Mockito.when((Object)testNode.hasProperty("exo:viewers")).thenReturn((Object)true);
        Mockito.when((Object)testNode.getProperty(ArgumentMatchers.anyString())).thenReturn((Object)property);
        Mockito.when((Object)testNode.getProperty("exo:viewers").getValue()).thenReturn((Object)value);
        Mockito.when((Object)testNode.getProperty("exo:viewers").getValue().getString()).thenReturn((Object)"user1,user2,user3");
        NewsArticlesViewsCountUpgrade plugin = new NewsArticlesViewsCountUpgrade(initParams, this.repositoryService, this.sessionProviderService);
        plugin.processUpgrade(null, null);
        Assert.assertEquals((long)2L, (long)plugin.getUpdatedNodes());
    }
}

