/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.jcr;

import io.meeds.news.model.News;
import io.meeds.news.service.NewsService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.upgrade.jcr.NewsArticlesUpgrade;
import org.exoplatform.services.attachments.storage.AttachmentStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.service.NoteService;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsArticlesUpgradeTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<MentionUtils> MENTION_UTILS = Mockito.mockStatic(MentionUtils.class);
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SessionProviderService sessionProviderService;
    @Mock
    private ManageableRepository repository;
    @Mock
    private RepositoryEntry repositoryEntry;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private NewsService newsService;
    @Mock
    private NoteService noteService;
    @Mock
    private MetadataService metadataService;
    @Mock
    private FileService fileService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private IndexingService indexingService;
    @Mock
    private SettingService settingService;
    @Mock
    private AttachmentStorage attachmentStorage;
    private NewsArticlesUpgrade newsArticlesUpgrade;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        MENTION_UTILS.close();
    }

    @Before
    public void setUp() {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        this.newsArticlesUpgrade = new NewsArticlesUpgrade(initParams, this.repositoryService, this.sessionProviderService, this.newsService, this.spaceService, this.activityManager, this.metadataService, this.fileService, this.noteService, this.identityManager, this.indexingService, this.attachmentStorage, this.settingService);
    }

    @Test
    public void testProcessUpgrade() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(ArgumentMatchers.anyString())).thenReturn((Object)identity);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(null)).thenReturn((Object)sessionProvider);
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)sessionProvider.getSession(ArgumentMatchers.anyString(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)session);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        NodeTypeManagerImpl nodetypeManager = (NodeTypeManagerImpl)Mockito.mock(NodeTypeManagerImpl.class);
        Mockito.when((Object)workspace.getNodeTypeManager()).thenReturn((Object)nodetypeManager);
        Mockito.when((Object)nodetypeManager.hasNodeType(ArgumentMatchers.anyString())).thenReturn((Object)true);
        QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
        Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)queryManager);
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)queryManager.createQuery(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"sql"))).thenReturn((Object)query);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        NodeIterator iterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)iterator);
        Node node1 = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)iterator.next()).thenReturn((Object)node1, new Object[]{node2});
        Mockito.when((Object)node1.hasProperty("publication:currentState")).thenReturn((Object)true);
        Property archivedProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node1.hasProperty("exo:archived")).thenReturn((Object)true);
        Mockito.when((Object)node1.getProperty("exo:archived")).thenReturn((Object)archivedProperty);
        Mockito.when((Object)archivedProperty.getBoolean()).thenReturn((Object)false);
        Property publishedStateProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node1.getProperty("publication:currentState")).thenReturn((Object)publishedStateProperty);
        Mockito.when((Object)publishedStateProperty.getString()).thenReturn((Object)"published");
        Property dateCreatedProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node1.hasProperty("exo:dateCreated")).thenReturn((Object)true);
        Mockito.when((Object)node1.getProperty("exo:dateCreated")).thenReturn((Object)dateCreatedProperty);
        Mockito.when((Object)dateCreatedProperty.getDate()).thenReturn((Object)((Calendar)Mockito.mock(Calendar.class)));
        Property dateModifiedProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node1.hasProperty("exo:dateModified")).thenReturn((Object)true);
        Mockito.when((Object)node1.getProperty("exo:dateModified")).thenReturn((Object)dateModifiedProperty);
        Mockito.when((Object)dateModifiedProperty.getDate()).thenReturn((Object)((Calendar)Mockito.mock(Calendar.class)));
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentPortalOwner()).thenReturn((Object)"root");
        MENTION_UTILS.when(() -> MentionUtils.substituteUsernames((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn((Object)"");
        News article = (News)Mockito.mock(News.class);
        Mockito.when((Object)article.getId()).thenReturn((Object)"1");
        Mockito.when((Object)article.getSpaceId()).thenReturn((Object)"1");
        Page page = new Page();
        page.setId("1");
        page.setAuthor("user");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("user")).thenReturn((Object)identity);
        PageVersion pageVersion = (PageVersion)Mockito.mock(PageVersion.class);
        Mockito.when((Object)pageVersion.getParent()).thenReturn((Object)page);
        Mockito.when((Object)this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(ArgumentMatchers.anyLong()), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)pageVersion);
        Mockito.when((Object)this.noteService.getNoteById(ArgumentMatchers.anyString())).thenReturn((Object)((Page)Mockito.mock(Page.class)));
        Mockito.when((Object)pageVersion.getId()).thenReturn((Object)"1");
        Mockito.when((Object)node1.hasNode("illustration")).thenReturn((Object)false);
        ArrayList<MetadataItem> metadataItems = new ArrayList<MetadataItem>();
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        metadataItems.add(metadataItem);
        Mockito.when((Object)node1.hasProperty("exo:activities")).thenReturn((Object)true);
        Property activitiesProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node1.getProperty("exo:activities")).thenReturn((Object)activitiesProperty);
        Mockito.when((Object)activitiesProperty.getString()).thenReturn((Object)"1:1;");
        Mockito.when((Object)node1.hasProperty("exo:viewsCount")).thenReturn((Object)true);
        Property viewsCountProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node1.getProperty("exo:viewsCount")).thenReturn((Object)viewsCountProperty);
        Mockito.when((Object)viewsCountProperty.getLong()).thenReturn((Object)1L);
        Mockito.when((Object)node1.hasProperty("exo:viewers")).thenReturn((Object)true);
        Property viewersProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node1.getProperty("exo:viewers")).thenReturn((Object)viewersProperty);
        Mockito.when((Object)viewersProperty.getString()).thenReturn((Object)"1");
        ExoSocialActivity exoSocialActivity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)this.activityManager.getActivity((String)ArgumentMatchers.any())).thenReturn((Object)exoSocialActivity);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject((MetadataKey)ArgumentMatchers.any(), (MetadataObject)ArgumentMatchers.any(MetadataObject.class))).thenReturn(metadataItems);
        Mockito.lenient().when((Object)node1.hasNode("illustration")).thenReturn((Object)true);
        Node illustrationNode = (Node)Mockito.mock(Node.class);
        Mockito.lenient().when((Object)node1.getNode("illustration")).thenReturn((Object)illustrationNode);
        Node illustrationContentNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)illustrationNode.getNode("jcr:content")).thenReturn((Object)illustrationContentNode);
        Mockito.when((Object)illustrationContentNode.getProperty("jcr:data")).thenReturn((Object)((Property)Mockito.mock(Property.class)));
        Mockito.when((Object)illustrationContentNode.getProperty("jcr:mimeType")).thenReturn((Object)((Property)Mockito.mock(Property.class)));
        Mockito.when((Object)illustrationNode.getProperty("exo:title")).thenReturn((Object)((Property)Mockito.mock(Property.class)));
        Mockito.when((Object)node1.hasProperty("exo:attachmentsIds")).thenReturn((Object)true);
        Property attachmentsIdsProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node1.getProperty("exo:attachmentsIds")).thenReturn((Object)attachmentsIdsProperty);
        Value value1 = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)value1.getString()).thenReturn((Object)"22121212");
        Value value2 = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)value2.getString()).thenReturn((Object)"443434343");
        Value[] attachmentsIdsPropertyValues = new Value[]{value1, value2};
        Mockito.when((Object)attachmentsIdsProperty.getValues()).thenReturn((Object)attachmentsIdsPropertyValues);
        Mockito.when((Object)node2.hasProperty("publication:currentState")).thenReturn((Object)true);
        Property stagedStateProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node2.getProperty("publication:currentState")).thenReturn((Object)stagedStateProperty);
        Mockito.when((Object)stagedStateProperty.getString()).thenReturn((Object)"staged");
        Mockito.when((Object)node2.hasProperty("publication:startPublishedDate")).thenReturn((Object)true);
        Property startTimeProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node2.getProperty("publication:startPublishedDate")).thenReturn((Object)startTimeProperty);
        Calendar startTimePropertyCalendar = (Calendar)Mockito.mock(Calendar.class);
        Mockito.when((Object)startTimeProperty.getDate()).thenReturn((Object)startTimePropertyCalendar);
        Mockito.when((Object)startTimePropertyCalendar.getTime()).thenReturn((Object)((Date)Mockito.mock(Date.class)));
        Method method = this.newsArticlesUpgrade.getClass().getDeclaredMethod("convertNewsNodeToNewEntity", Node.class, Node.class);
        method.setAccessible(true);
        News news1 = (News)method.invoke((Object)this.newsArticlesUpgrade, node1, null);
        News news2 = (News)method.invoke((Object)this.newsArticlesUpgrade, node2, null);
        Mockito.when((Object)this.newsService.createNewsArticlePage(news1, "")).thenReturn((Object)article);
        Mockito.when((Object)this.newsService.createNewsArticlePage(news2, "")).thenReturn((Object)article);
        this.newsArticlesUpgrade.processUpgrade("1.0", "2.0");
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)2))).createNewsArticlePage((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NoteService)Mockito.verify((Object)this.noteService, (VerificationMode)Mockito.times((int)2))).getPublishedVersionByPageIdAndLang(Long.valueOf(ArgumentMatchers.anyLong()), (String)ArgumentMatchers.nullable(String.class));
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)6))).getMetadataItemsByMetadataAndObject((MetadataKey)ArgumentMatchers.any(), (MetadataObject)ArgumentMatchers.any(MetadataObject.class));
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)6))).updateMetadataItem((MetadataItem)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)1))).getActivity((String)ArgumentMatchers.any());
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)1))).updateActivity((ExoSocialActivity)ArgumentMatchers.any(ExoSocialActivity.class), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void shouldProceedToUpgrade() {
        SettingValue settingValue = (SettingValue)Mockito.mock(SettingValue.class);
        UpgradePluginExecutionContext context = new UpgradePluginExecutionContext("0.9", 1);
        Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn(null);
        this.newsArticlesUpgrade.shouldProceedToUpgrade("0.9", "1.0", context);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (SettingValue)ArgumentMatchers.any());
        Mockito.reset((Object[])new SettingService[]{this.settingService});
        Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)settingValue);
        context.setVersion("1.2");
        this.newsArticlesUpgrade.shouldProceedToUpgrade("1.2", "1.0", context);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)0))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (SettingValue)ArgumentMatchers.any());
    }
}

