/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade;

import io.meeds.notes.model.NoteMetadataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.upgrade.ContentArticlePropertiesUpgrade;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataFilter;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.service.NoteService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContentArticlePropertiesUpgradeTest {
    @Mock
    private NoteService noteService;
    @Mock
    private MetadataService metadataService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private UserACL userACL;
    @Mock
    private SettingService settingService;
    private ContentArticlePropertiesUpgrade contentArticlePropertiesUpgrade;
    private static final MetadataKey NOTES_METADATA_KEY = new MetadataKey("notes", "notes", 0L);
    private static final String ILLUSTRATION_ID = "illustrationId";
    private static final String SUMMARY = "summary";

    @Before
    public void setUp() {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        this.contentArticlePropertiesUpgrade = new ContentArticlePropertiesUpgrade(initParams, this.noteService, this.metadataService, this.identityManager, this.spaceService, this.userACL, this.settingService);
    }

    @Test
    public void processUpgrade() throws Exception {
        MetadataItem page = new MetadataItem();
        MetadataItem draftOfPage = new MetadataItem();
        MetadataItem draftOfPage2 = new MetadataItem();
        MetadataItem draft = new MetadataItem();
        page.setId(1L);
        page.setObjectType("newsPageVersion");
        page.setObjectId("1");
        page.setProperties(Map.of(ILLUSTRATION_ID, "1", SUMMARY, "test summary"));
        draftOfPage.setId(2L);
        draftOfPage.setObjectType("newsLatestDraftPage");
        draftOfPage.setObjectId("2");
        draftOfPage.setProperties(Map.of(ILLUSTRATION_ID, "2", SUMMARY, "test summary"));
        draftOfPage2.setId(4L);
        draftOfPage2.setObjectType("newsLatestDraftPage");
        draftOfPage2.setObjectId("6");
        draftOfPage2.setProperties(Map.of(ILLUSTRATION_ID, "4", SUMMARY, "test summary"));
        draft.setId(1L);
        draft.setObjectId("3");
        draft.setObjectType("newsDraftPage");
        draft.setProperties(Map.of(ILLUSTRATION_ID, "3", SUMMARY, "test summary"));
        Page parentPage = new Page();
        parentPage.setId("2");
        parentPage.setAuthor("user");
        PageVersion pageVersion = new PageVersion();
        pageVersion.setId("1");
        pageVersion.setParent(parentPage);
        pageVersion.setAuthor("user");
        DraftPage draftOfExistingPage = new DraftPage();
        draftOfExistingPage.setId("2");
        draftOfExistingPage.setAuthor("user");
        DraftPage draftOfExistingPage2 = new DraftPage();
        draftOfExistingPage2.setId("6");
        DraftPage draftPage = new DraftPage();
        draftPage.setId("3");
        draftPage.setAuthor("user");
        MetadataItem notePage = new MetadataItem();
        notePage.setId(5L);
        notePage.setObjectType("notePage");
        notePage.setObjectId("2");
        List<MetadataItem> metadataItems = List.of(page, draftOfPage, draftOfPage2, draft);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.metadataService.getMetadataItemsByFilter((MetadataFilter)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(metadataItems);
        Mockito.when((Object)this.noteService.getPageVersionById(Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn((Object)pageVersion);
        Mockito.when((Object)this.noteService.getDraftNoteById(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)draftOfExistingPage, (Object[])new DraftPage[]{draftOfExistingPage2, draftPage});
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(ArgumentMatchers.anyString())).thenReturn((Object)identity);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject(NOTES_METADATA_KEY, (MetadataObject)new NoteMetadataObject("noteDraftPage", "3", null, 0L))).thenReturn(new ArrayList());
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject(NOTES_METADATA_KEY, (MetadataObject)new NoteMetadataObject("noteDraftPage", "2", null, 0L))).thenReturn(new ArrayList());
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject(NOTES_METADATA_KEY, (MetadataObject)new NoteMetadataObject("notePage", "2", null, 0L))).thenReturn(List.of(notePage));
        Mockito.when((Object)this.userACL.getSuperUser()).thenReturn((Object)"root");
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        this.contentArticlePropertiesUpgrade.processUpgrade(null, null);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)2))).createMetadataItem((MetadataObject)ArgumentMatchers.any(), (MetadataKey)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldProceedToUpgrade() {
        SettingValue settingValue = (SettingValue)Mockito.mock(SettingValue.class);
        Mockito.when((Object)settingValue.getValue()).thenReturn((Object)"false");
        Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn(null, (Object[])new SettingValue[]{settingValue});
        Assert.assertFalse((boolean)this.contentArticlePropertiesUpgrade.shouldProceedToUpgrade("1.0", "1.2"));
        Assert.assertFalse((boolean)this.contentArticlePropertiesUpgrade.shouldProceedToUpgrade("1.0", "1.2"));
        Mockito.when((Object)settingValue.getValue()).thenReturn((Object)"true");
        Assert.assertTrue((boolean)this.contentArticlePropertiesUpgrade.shouldProceedToUpgrade("1.0", "1.2"));
    }
}

