/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Query;
import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.upgrade.ArticleAttachmentsUpgradePlugin;
import org.exoplatform.services.attachments.storage.AttachmentStorage;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.service.NoteService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ArticleAttachmentsUpgradePluginTest {
    @Mock
    private SettingService settingService;
    @Mock
    private NoteService noteService;
    @Mock
    private EntityManagerService entityManagerService;
    @Mock
    private AttachmentStorage attachmentStorage;
    @Mock
    private EntityManager entityManager;
    @Mock
    private EntityTransaction transaction;
    @Mock
    PortalContainer container;
    private ArticleAttachmentsUpgradePlugin articleAttachmentsUpgradePlugin;
    private static final String ARTICLES_UPGRADE_EXECUTED_KEY = "articlesUpgradeExecuted";

    @Before
    public void setUp() {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        this.articleAttachmentsUpgradePlugin = new ArticleAttachmentsUpgradePlugin(initParams, this.entityManagerService, this.settingService, this.noteService, this.attachmentStorage, this.container);
        Mockito.when((Object)this.entityManagerService.getEntityManager()).thenReturn((Object)this.entityManager);
        Mockito.when((Object)this.entityManager.getTransaction()).thenReturn((Object)this.transaction);
    }

    @Test
    public void shouldNotProceedToUpgrade_WhenSettingIsFalse() {
        SettingValue settingValue = (SettingValue)Mockito.mock(SettingValue.class);
        Mockito.when((Object)settingValue.getValue()).thenReturn((Object)"false");
        Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)settingValue, null);
        boolean result = this.articleAttachmentsUpgradePlugin.shouldProceedToUpgrade("6.5.4", "7.0.0");
        Assert.assertFalse((boolean)result);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)ARTICLES_UPGRADE_EXECUTED_KEY));
    }

    @Test
    public void processUpgrade_ShouldLinkAttachmentsAndCommitTransaction() {
        Mockito.when((Object)this.entityManager.getTransaction().isActive()).thenReturn((Object)false).thenReturn((Object)true);
        ((EntityTransaction)Mockito.doNothing().when((Object)this.transaction)).begin();
        ((EntityTransaction)Mockito.doNothing().when((Object)this.transaction)).commit();
        List<Object[]> mockResults = Collections.singletonList(new Object[]{"123", "attachment1;attachment2"});
        Query selectQuery = (Query)Mockito.mock(Query.class);
        Query deleteQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)this.entityManager.createNativeQuery((String)ArgumentMatchers.any())).thenReturn((Object)selectQuery).thenReturn((Object)deleteQuery);
        Mockito.when((Object)selectQuery.getResultList()).thenReturn(mockResults);
        PageVersion mockPageVersion = (PageVersion)Mockito.mock(PageVersion.class);
        Mockito.when((Object)this.noteService.getPageVersionById(Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn((Object)mockPageVersion);
        Mockito.when((Object)mockPageVersion.getParent()).thenReturn(null);
        this.articleAttachmentsUpgradePlugin.processUpgrade("6.5.4", "7.0.0");
        ((EntityTransaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.times((int)1))).begin();
        ((AttachmentStorage)Mockito.verify((Object)this.attachmentStorage, (VerificationMode)Mockito.times((int)2))).linkAttachmentToEntity(((Long)ArgumentMatchers.any(Long.class)).longValue(), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class));
        ((EntityTransaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.times((int)1))).commit();
    }
}

