/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.noformat;

import java.util.Collections;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component(value="noformat")
public class NoFormatMacro
extends AbstractMacro<Object> {
    private static final String DESCRIPTION = "Makes a pre-formatted block of text with no syntax highlighting";
    private static final String CONTENT_DESCRIPTION = "block of text";

    public NoFormatMacro() {
        super("NoFormat", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), Object.class);
        this.setDefaultCategory("Formatting");
    }

    public List<Block> execute(Object parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (content != null) {
            String contentWithCode = "<pre><code class=\"language-plaintext\">" + content + "</code></pre>";
            RawBlock rawBlock = new RawBlock(contentWithCode, Syntax.XHTML_1_0);
            return Collections.singletonList(rawBlock);
        }
        return Collections.emptyList();
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

