/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.jira.displayer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jdom2.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BulletedListBlock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.internal.macro.jira.displayer.AbstractJIRADisplayer;
import org.xwiki.rendering.macro.jira.JIRAMacroParameters;

@Component
@Named(value="list")
@Singleton
public class ListJIRADisplayer
extends AbstractJIRADisplayer {
    private static final List<String> FIELDS = Arrays.asList("status", "key", "summary");

    @Override
    public List<Block> display(Collection<Element> issues, JIRAMacroParameters parameters) {
        ArrayList<ListItemBlock> listItemBlocks = new ArrayList<ListItemBlock>();
        for (Element issue : issues) {
            ArrayList<Object> itemBlocks = new ArrayList<Object>();
            Iterator<String> it = this.getFields(parameters).iterator();
            while (it.hasNext()) {
                String field = it.next();
                itemBlocks.addAll(this.getFieldDisplayer(field).displayField(field, issue));
                if (!it.hasNext()) continue;
                itemBlocks.add(new SpaceBlock());
            }
            listItemBlocks.add(new ListItemBlock(itemBlocks));
        }
        return Arrays.asList(new BulletedListBlock(listItemBlocks));
    }

    @Override
    protected List<String> getDefaultFields() {
        return FIELDS;
    }
}

