/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.jira.source;

import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.jira.JIRADataSource;

public abstract class AbstractJIRADataSource
implements JIRADataSource {
    private static final String JQL_URL_PREFIX = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=";
    private SAXBuilder saxBuilder = new SAXBuilder();

    protected Map<String, Element> buildIssues(Document document) {
        LinkedHashMap<String, Element> issues = new LinkedHashMap<String, Element>();
        for (Element item : document.getRootElement().getChild("channel").getChildren("item")) {
            issues.put(item.getChildText("key"), item);
        }
        return issues;
    }

    public Document getXMLDocument(String jiraURL, String jqlQuery) throws MacroExecutionException {
        Document document;
        try {
            document = this.saxBuilder.build(new URL(String.format("%s%s%s", jiraURL, JQL_URL_PREFIX, URLEncoder.encode(jqlQuery, "UTF-8"))));
        }
        catch (Exception e) {
            throw new MacroExecutionException(String.format("Failed to retrieve JIRA data from [%s] for JQL [%s]", jiraURL, jqlQuery), (Throwable)e);
        }
        return document;
    }
}

