/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.migration;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.migration.PageContentMigrationServiceImpl;
import org.picocontainer.Startable;

public class WikiPageContentMigrationUpgradePlugin
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(WikiPageContentMigrationUpgradePlugin.class);
    private PageContentMigrationServiceImpl migrationService = (PageContentMigrationServiceImpl)ExoContainerContext.getService(PageContentMigrationServiceImpl.class);

    public WikiPageContentMigrationUpgradePlugin(SettingService settingService, InitParams initParams) {
    }

    public void start() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ExecutorService executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "Wiki-PageSyntaxMigration"));
        executorService.execute(() -> {
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            try {
                ConversationState.setCurrent((ConversationState)new ConversationState(new Identity(IdentityConstants.SYSTEM)));
                LOG.info((Object)"== Starting Wiki page syntax migration");
                this.migrationService.migrateAllPages();
                this.migrationService.migrateAllPagesTemplates();
                this.migrationService.migrateAllPagesVersions();
                LOG.info((Object)"== Wiki pages syntax migration - Migration finished");
            }
            catch (Exception e) {
                LOG.error((Object)"Error while migrating wiki pages fom XWiki syntax to HTML", (Throwable)e);
            }
            finally {
                ConversationState.setCurrent(null);
            }
        });
    }

    public void stop() {
    }
}

