/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.apt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.reflext.spi.model.AnnotationModel;

public abstract class JavaxLangAnnotationModel<E>
implements AnnotationModel<Object, E, AnnotationMirror, ExecutableElement> {
    public Object getAnnotationType(AnnotationMirror annotationMirror) {
        return annotationMirror.getAnnotationType();
    }

    public Collection<ExecutableElement> getAnnotationParameters(AnnotationMirror annotation) {
        return ElementFilter.methodsIn(annotation.getAnnotationType().asElement().getEnclosedElements());
    }

    public String getAnnotationParameterName(ExecutableElement parameter) {
        return parameter.getSimpleName().toString();
    }

    public Object getAnnotationParameterType(ExecutableElement parameter) {
        return parameter.getReturnType();
    }

    public List<?> getAnnotationParameterValue(AnnotationMirror annotation, ExecutableElement parameter) {
        AnnotationValue annotationValue = annotation.getElementValues().get(parameter);
        if (annotationValue == null) {
            throw new UnsupportedOperationException();
        }
        Object value = annotationValue.getValue();
        if (value instanceof List) {
            ArrayList<Object> list = new ArrayList<Object>((List)value);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.unwrap(list.get(i)));
            }
            return list;
        }
        return Arrays.asList(this.unwrap(value));
    }

    private Object unwrap(Object o) {
        if (o instanceof VariableElement) {
            return ((VariableElement)o).getSimpleName().toString();
        }
        if (o instanceof AnnotationValue) {
            return ((AnnotationValue)o).getValue();
        }
        return o;
    }
}

