/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class XMLUtils {
    public static final Pattern INDEX_PATTERN = Pattern.compile("_(\\d+)");
    private static final Map<Class<?>, Object> DEFAULTS = new HashMap();
    private static final Set<Class<?>> SIMPLECLASSES;

    private XMLUtils() {
    }

    public static boolean isSimpleType(Type type) {
        boolean simpleType = false;
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            simpleType = SIMPLECLASSES.contains(typeClass) || Number.class.isAssignableFrom(typeClass) || typeClass.isPrimitive() || typeClass.isEnum();
        }
        return simpleType;
    }

    public static Object emptyValue(Class<?> type) {
        Object defaultValue = null;
        if (DEFAULTS.containsKey(type)) {
            defaultValue = DEFAULTS.get(type);
        } else {
            try {
                defaultValue = type.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    static {
        DEFAULTS.put(Boolean.TYPE, false);
        DEFAULTS.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULTS.put(Byte.TYPE, (byte)0);
        DEFAULTS.put(Short.TYPE, (short)0);
        DEFAULTS.put(Integer.TYPE, 0);
        DEFAULTS.put(Long.TYPE, 0L);
        DEFAULTS.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULTS.put(Double.TYPE, 0.0);
        DEFAULTS.put(Map.class, new LinkedHashMap());
        DEFAULTS.put(Set.class, new LinkedHashSet());
        DEFAULTS.put(List.class, new ArrayList());
        DEFAULTS.put(Collection.class, new ArrayList());
        SIMPLECLASSES = new HashSet<Class>(Arrays.asList(String.class, Character.class, Boolean.class, byte[].class));
    }
}

