/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.migration;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.jdbc.migration.AbstractMigrationService;
import org.exoplatform.portal.jdbc.migration.AppReferencesMigrationService;
import org.exoplatform.portal.jdbc.migration.MigrationContext;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageServiceImpl;
import org.exoplatform.portal.pom.config.POMDataStorage;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PageKey;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.listener.ListenerService;

public class PageMigrationService
extends AbstractMigrationService {
    public static final String EVENT_LISTENER_KEY = "PORTAL_PAGES_MIGRATION";
    private PageService pageService;
    private PageServiceImpl jcrPageService;

    public PageMigrationService(InitParams initParams, POMDataStorage pomStorage, ModelDataStorage modelStorage, PageService pageService, PageServiceImpl jcrPageService, ListenerService listenerService, RepositoryService repoService, SettingService settingService, AppReferencesMigrationService appReferencesMigrationService) {
        super(initParams, pomStorage, modelStorage, listenerService, repoService, settingService, appReferencesMigrationService);
        this.pageService = pageService;
        this.jcrPageService = jcrPageService;
    }

    @Override
    public void doMigrate(PortalKey siteToMigrateKey) throws Exception {
        QueryResult<PageContext> pages;
        HashSet<String> failedPages = new HashSet<String>();
        int offset = 0;
        do {
            if (MigrationContext.isForceStop()) {
                throw new InterruptedException();
            }
            pages = this.getPagesIterator(siteToMigrateKey, offset);
            Iterator pageItr = pages.iterator();
            while (pageItr.hasNext()) {
                if (MigrationContext.isForceStop()) {
                    throw new InterruptedException();
                }
                ++offset;
                PageContext page = (PageContext)pageItr.next();
                org.exoplatform.portal.mop.page.PageKey key = page.getKey();
                if (MigrationContext.isPageMigrated(key)) continue;
                try {
                    SiteKey siteKey = key.getSite();
                    PageContext created = this.pageService.loadPage(key);
                    PageKey pomPageKey = new PageKey(siteKey.getTypeName(), siteKey.getName(), key.getName());
                    PageData pageDataToMigrate = this.pomStorage.getPage(pomPageKey);
                    String storageId = null;
                    if (created == null) {
                        this.pageService.savePage(page);
                    } else {
                        PageData data = this.modelStorage.getPage(pomPageKey);
                        storageId = data.getStorageId();
                    }
                    List<ComponentData> pageLayout = this.migrateComponents(pageDataToMigrate.getChildren());
                    PageData migratedPage = new PageData(storageId, pageDataToMigrate.getId(), pageDataToMigrate.getName(), pageDataToMigrate.getIcon(), pageDataToMigrate.getTemplate(), pageDataToMigrate.getFactoryId(), pageDataToMigrate.getTitle(), pageDataToMigrate.getDescription(), pageDataToMigrate.getWidth(), pageDataToMigrate.getHeight(), pageDataToMigrate.getAccessPermissions(), pageLayout, pageDataToMigrate.getOwnerType(), pageDataToMigrate.getOwnerId(), pageDataToMigrate.getEditPermission(), pageDataToMigrate.isShowMaxWindow(), pageDataToMigrate.getMoveAppsPermissions(), pageDataToMigrate.getMoveContainersPermissions());
                    this.modelStorage.save(migratedPage);
                    MigrationContext.setPageMigrated(key);
                    if (offset % this.limitThreshold == 0) {
                        MigrationContext.restartTransaction();
                    }
                    created = this.pageService.loadPage(page.getKey());
                    this.broadcastListener(created, created.getKey().toString());
                }
                catch (Exception ex) {
                    this.log.error((Object)("Exception during migration page: " + page.getKey()), (Throwable)ex);
                    failedPages.add(page.getKey().format());
                }
            }
            MigrationContext.restartTransaction();
        } while (pages.getSize() > 0);
        if (!failedPages.isEmpty()) {
            throw new IllegalStateException("Some errors was encountered while migrating pages " + failedPages);
        }
    }

    @Override
    public void doRemove(PortalKey siteToMigrateKey) throws Exception {
        QueryResult<PageContext> pages;
        int errors = 0;
        int offset = 0;
        HashSet<org.exoplatform.portal.mop.page.PageKey> deletedPages = new HashSet<org.exoplatform.portal.mop.page.PageKey>();
        do {
            pages = this.getPagesIterator(siteToMigrateKey, offset);
            for (PageContext page : pages) {
                org.exoplatform.portal.mop.page.PageKey key = page.getKey();
                String siteType = key.getSite().getTypeName();
                String siteId = key.getSite().getName();
                try {
                    if (deletedPages.contains(key)) {
                        this.log.info("|  ---- | IGNORE::page {}::{}::{} (already deleted)", new Object[]{siteType, siteId, key.getName()});
                        continue;
                    }
                    deletedPages.add(key);
                    this.log.info("|  ---- | REMOVE::page {}::{}::{}", new Object[]{siteType, siteId, key.getName()});
                    this.jcrPageService.destroyPage(key);
                }
                catch (Exception ex) {
                    this.log.error("Can't remove page {}::{}::{}", new Object[]{siteType, siteId, key.getName(), ex});
                    ++errors;
                }
            }
            MigrationContext.restartTransaction();
        } while (pages.getSize() > 0 && errors < this.limitThreshold);
        if (errors > 0) {
            throw new IllegalStateException("Some errors (" + errors + ") was encountered while removing pages of site " + siteToMigrateKey.getType() + "/" + siteToMigrateKey.getId() + "");
        }
    }

    @Override
    protected String getListenerKey() {
        return EVENT_LISTENER_KEY;
    }

    private QueryResult<PageContext> getPagesIterator(PortalKey siteToMigrateKey, int offset) {
        return this.jcrPageService.findPages(offset, this.limitThreshold, SiteType.valueOf((String)siteToMigrateKey.getType().toUpperCase()), siteToMigrateKey.getId().replaceAll("'", "''"), null, null);
    }
}

