/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management;

import org.exoplatform.portal.mop.management.binding.MopBindingProvider;
import org.exoplatform.portal.mop.management.operations.MopImportResource;
import org.exoplatform.portal.mop.management.operations.MopReadResource;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationExportResource;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationReadConfig;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationReadResource;
import org.exoplatform.portal.mop.management.operations.page.PageExportResource;
import org.exoplatform.portal.mop.management.operations.page.PageReadConfig;
import org.exoplatform.portal.mop.management.operations.page.PageReadResource;
import org.exoplatform.portal.mop.management.operations.site.SiteLayoutExportResource;
import org.exoplatform.portal.mop.management.operations.site.SiteLayoutReadConfig;
import org.exoplatform.portal.mop.management.operations.site.SiteLayoutReadResource;
import org.exoplatform.portal.mop.management.operations.site.SiteReadResource;
import org.exoplatform.portal.mop.management.operations.site.SiteTypeReadResource;
import org.gatein.management.api.ComponentRegistration;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.spi.ExtensionContext;
import org.gatein.management.spi.ManagementExtension;

public class MopManagementExtension
implements ManagementExtension {
    public void initialize(ExtensionContext context) {
        ComponentRegistration registration = context.registerManagedComponent("mop");
        registration.registerBindingProvider((BindingProvider)MopBindingProvider.INSTANCE);
        ManagedResource.Registration mop = registration.registerManagedResource(MopManagementExtension.description("MOP (Model Object for Portal) Managed Resource, responsible for handling management operations on navigation, pages, and sites."));
        mop.registerOperationHandler("import-resource", (OperationHandler)new MopImportResource(), MopManagementExtension.description("Imports mop data from an exported zip file."));
        mop.registerOperationHandler("read-resource", (OperationHandler)new MopReadResource(), MopManagementExtension.description("Lists available site types for a portal"));
        ManagedResource.Registration sitetypes = mop.registerSubResource("{site-type}sites", MopManagementExtension.description("Management resource responsible for handling management operations on a specific site type for a portal."));
        sitetypes.registerOperationHandler("read-resource", (OperationHandler)new SiteTypeReadResource(), MopManagementExtension.description("Lists available sites for a given site type."));
        ManagedResource.Registration sites = sitetypes.registerSubResource("{site-name: .*}", MopManagementExtension.description("Management resource responsible for handling management operations on a specific site."));
        sites.registerOperationHandler("read-resource", (OperationHandler)new SiteReadResource(), MopManagementExtension.description("Lists available resources for a given site (ie pages, navigation, site layout)"));
        this.siteLayoutManagementRegistration(sites);
        this.pageManagementRegistration(sites);
        this.navigationManagementRegistration(sites);
    }

    private void siteLayoutManagementRegistration(ManagedResource.Registration sites) {
        ManagedResource.Registration siteLayout = sites.registerSubResource("{site-layout: portal|group|user}", MopManagementExtension.description("Management resource responsible for handling management operations for a site's layout."));
        siteLayout.registerOperationHandler("read-resource", (OperationHandler)new SiteLayoutReadResource(), MopManagementExtension.description("The site layout resource."));
        siteLayout.registerOperationHandler("read-config", (OperationHandler)new SiteLayoutReadConfig(), MopManagementExtension.description("Reads site layout data for a specific site as configuration xml."));
        siteLayout.registerOperationHandler("export-resource", (OperationHandler)new SiteLayoutExportResource(), MopManagementExtension.description("Exports site layout configuration xml as a zip file."));
    }

    private void pageManagementRegistration(ManagedResource.Registration sites) {
        ManagedResource.Registration pages = sites.registerSubResource("pages", MopManagementExtension.description("Management resource responsible for handling management operations for pages of a site."));
        pages.registerOperationHandler("read-resource", (OperationHandler)new PageReadResource(), MopManagementExtension.description("Lists available pages at a specified address."), true);
        pages.registerOperationHandler("read-config", (OperationHandler)new PageReadConfig(), MopManagementExtension.description("Reads pages as configuration xml at a specified address."), true);
        pages.registerOperationHandler("export-resource", (OperationHandler)new PageExportResource(), MopManagementExtension.description("Exports pages configuration xml as a zip file."), true);
        pages.registerSubResource("{page-name}", MopManagementExtension.description("Page resource representing an individual page of a site."));
    }

    private void navigationManagementRegistration(ManagedResource.Registration sites) {
        ManagedResource.Registration navigation = sites.registerSubResource("navigation", MopManagementExtension.description("Management resource responsible for handling management operations on a sites navigation."));
        navigation.registerOperationHandler("read-resource", (OperationHandler)new NavigationReadResource(), MopManagementExtension.description("Available navigation nodes at the specified address."), true);
        navigation.registerOperationHandler("read-config", (OperationHandler)new NavigationReadConfig(), MopManagementExtension.description("Reads navigation as configuration xml at a specified address."), true);
        navigation.registerOperationHandler("export-resource", (OperationHandler)new NavigationExportResource(), MopManagementExtension.description("Exports navigation configuration xml as a zip file."), true);
        navigation.registerSubResource("{nav-uri: .*}", MopManagementExtension.description("Management resource responsible for handling management operations on specific navigation nodes."));
    }

    public void destroy() {
    }

    private static ManagedDescription description(final String description) {
        return new ManagedDescription(){

            public String getDescription() {
                return description;
            }
        };
    }
}

