/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMTask;
import org.exoplatform.portal.pom.config.tasks.Mapper;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;

public abstract class SearchTask<T>
implements POMTask<LazyPageList<T>> {
    protected final Query<T> q;

    public SearchTask(Query<T> query) {
        this.q = query;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[query=" + this.q + "]";
    }

    public static class FindSiteKey
    extends SearchTask<PortalKey> {
        public static Serializable PORTAL_KEY = "FindPortalSiteKey";
        public static Serializable GROUP_KEY = "FindGroupSiteKey";
        private final ObjectType<Site> type;
        private final Serializable key;

        public FindSiteKey(Query<PortalKey> siteQuery) {
            super(siteQuery);
            Serializable key;
            ObjectType type;
            if ("portal".equals(siteQuery.getOwnerType())) {
                type = ObjectType.PORTAL_SITE;
                key = PORTAL_KEY;
            } else if ("group".equals(siteQuery.getOwnerType())) {
                type = ObjectType.GROUP_SITE;
                key = GROUP_KEY;
            } else {
                throw new IllegalArgumentException("Invalid site type " + siteQuery.getOwnerType());
            }
            this.type = type;
            this.key = key;
        }

        public ObjectType<Site> getType() {
            return this.type;
        }

        public Serializable getKey() {
            return this.key;
        }

        @Override
        public LazyPageList<PortalKey> run(POMSession session) {
            Workspace workspace = session.getWorkspace();
            Collection sites = workspace.getSites(this.type);
            final ArrayList<PortalKey> keys = new ArrayList<PortalKey>(sites.size());
            for (Site site : sites) {
                keys.add(new PortalKey(this.q.getOwnerType(), site.getName()));
            }
            ListAccess<PortalKey> la = new ListAccess<PortalKey>(){

                public PortalKey[] load(int index, int length) throws Exception {
                    PortalKey[] result = new PortalKey[length];
                    for (int i = 0; i < length; ++i) {
                        result[i] = (PortalKey)keys.get(index++);
                    }
                    return result;
                }

                public int getSize() throws Exception {
                    return keys.size();
                }
            };
            return new LazyPageList((ListAccess)la, 10);
        }
    }

    public static class FindSite
    extends SearchTask<PortalData> {
        public FindSite(Query<PortalData> siteQuery) {
            super(siteQuery);
        }

        @Override
        public LazyPageList<PortalData> run(final POMSession session) {
            Workspace workspace = session.getWorkspace();
            String ownerType = this.q.getOwnerType();
            ObjectType<Site> siteType = ownerType == null ? ObjectType.PORTAL_SITE : Mapper.parseSiteType(ownerType);
            final Collection portals = workspace.getSites(siteType);
            final Iterator iterator = portals.iterator();
            ListAccess<PortalData> la = new ListAccess<PortalData>(){

                public PortalData[] load(int index, int length) throws Exception {
                    Mapper mapper = new Mapper(session);
                    PortalData[] result = new PortalData[length];
                    for (int i = 0; i < length; ++i) {
                        result[i] = mapper.load((Site)iterator.next());
                    }
                    return result;
                }

                public int getSize() throws Exception {
                    return portals.size();
                }
            };
            return new LazyPageList((ListAccess)la, 10);
        }
    }

    public static class FindPortletPreferences
    extends SearchTask<PortletPreferences> {
        public FindPortletPreferences(Query<PortletPreferences> portletPreferencesQuery) {
            super(portletPreferencesQuery);
        }

        @Override
        public LazyPageList<PortletPreferences> run(POMSession session) {
            return new LazyPageList((ListAccess)new ListAccess<PortletPreferences>(){

                public PortletPreferences[] load(int index, int length) throws Exception {
                    throw new AssertionError();
                }

                public int getSize() throws Exception {
                    return 0;
                }
            }, 10);
        }
    }
}

