/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.anchor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.wiki.rendering.macro.anchor.AnchorMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component(value="anchor")
public class AnchorMacro
extends AbstractMacro<AnchorMacroParameters> {
    private static final String DESCRIPTION = "Render an anchor. By access a anchor link, user can go to its position";

    public AnchorMacro() {
        super("Anchor", DESCRIPTION, AnchorMacroParameters.class);
        this.setDefaultCategory("Navigation");
    }

    public List<Block> execute(AnchorMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        String anchorName = parameters.getName();
        String anchor = "H" + anchorName;
        DocumentResourceReference documentReference = new DocumentResourceReference(null);
        documentReference.setAnchor(anchor);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", anchor);
        ArrayList<WordBlock> inner = new ArrayList<WordBlock>();
        inner.add(new WordBlock(""));
        LinkBlock anchorBlock = new LinkBlock(inner, (ResourceReference)documentReference, false, params);
        return Collections.singletonList(anchorBlock);
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

