/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.SecurityReferenceFactory;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.internal.XWikiBridge;

@Component
@Singleton
public class DefaultSecurityReferenceFactory
implements SecurityReferenceFactory {
    @Inject
    private XWikiBridge wikiBridge;
    private SecurityReference mainWikiReference;

    private SecurityReference getMainWikiReference() {
        if (this.mainWikiReference == null) {
            this.mainWikiReference = new SecurityReference((EntityReference)this.wikiBridge.getMainWikiReference());
        }
        return this.mainWikiReference;
    }

    @Override
    public SecurityReference newEntityReference(EntityReference reference) {
        return new SecurityReference(reference, this.getMainWikiReference());
    }

    @Override
    public UserSecurityReference newUserReference(DocumentReference reference) {
        return new UserSecurityReference(reference, this.getMainWikiReference());
    }

    @Override
    public GroupSecurityReference newGroupReference(DocumentReference reference) {
        return new GroupSecurityReference(reference, this.getMainWikiReference());
    }
}

