/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.binding.xml.portal.redirects;

import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.portal.config.model.RedirectCondition;
import org.exoplatform.portal.mop.management.binding.xml.Element;
import org.exoplatform.portal.mop.management.binding.xml.portal.redirects.DevicePropertyConditionXmlHandler;
import org.exoplatform.portal.mop.management.binding.xml.portal.redirects.UserAgentConditionXmlHandler;
import org.gatein.common.xml.stax.CollectionXmlHandler;
import org.gatein.common.xml.stax.navigator.Exceptions;
import org.gatein.common.xml.stax.navigator.StaxNavUtils;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.staxnav.StaxNavigator;

public class ConditionXmlHandler
extends CollectionXmlHandler<RedirectCondition, Element> {
    private final UserAgentConditionXmlHandler userAgentXmlHandler;
    private final DevicePropertyConditionXmlHandler devicePropertyXmlHandler;

    public ConditionXmlHandler() {
        this(new UserAgentConditionXmlHandler(), new DevicePropertyConditionXmlHandler());
    }

    public ConditionXmlHandler(UserAgentConditionXmlHandler userAgentXmlHandler, DevicePropertyConditionXmlHandler devicePropertyXmlHandler) {
        super((Object)Element.CONDITIONS, (Object)Element.CONDITION);
        this.userAgentXmlHandler = userAgentXmlHandler;
        this.devicePropertyXmlHandler = devicePropertyXmlHandler;
    }

    protected RedirectCondition readElement(StaxNavigator<Element> navigator) {
        if (navigator.getName() != Element.CONDITION) {
            throw Exceptions.expectedElement(navigator, (Object)((Object)Element.CONDITION));
        }
        RedirectCondition condition = new RedirectCondition();
        Element element = (Element)((Object)navigator.child());
        if (element != Element.NAME) {
            throw Exceptions.expectedElement(navigator, (Object)((Object)Element.NAME));
        }
        condition.setName(StaxNavUtils.getRequiredContent(navigator, (boolean)true));
        boolean userAgent = false;
        boolean deviceProperties = false;
        block5: while (navigator.sibling() != null) {
            switch ((Element)((Object)navigator.getName())) {
                case USER_AGENT: {
                    if (userAgent || deviceProperties) {
                        throw Exceptions.unexpectedElement(navigator);
                    }
                    userAgent = true;
                    condition.setUserAgentConditions(this.userAgentXmlHandler.read((StaxNavigator<Element>)navigator.fork()));
                    continue block5;
                }
                case DEVICE_PROPERTIES: {
                    if (deviceProperties) {
                        throw Exceptions.unexpectedElement(navigator);
                    }
                    deviceProperties = true;
                    condition.setDeviceProperties((ArrayList)this.devicePropertyXmlHandler.read(navigator.fork()));
                    continue block5;
                }
                case UNKNOWN: {
                    throw Exceptions.unknownElement(navigator);
                }
            }
            throw Exceptions.unexpectedElement(navigator);
        }
        return condition;
    }

    protected void writeElement(StaxWriter<Element> writer, RedirectCondition condition) {
        if (condition == null) {
            return;
        }
        writer.writeStartElement((Object)Element.CONDITION);
        writer.writeElement((Object)Element.NAME, condition.getName());
        this.userAgentXmlHandler.write(writer, condition.getUserAgentConditions());
        this.devicePropertyXmlHandler.write(writer, condition.getDeviceProperties());
        writer.writeEndElement();
    }

    protected Collection<RedirectCondition> createCollection() {
        return new ArrayList<RedirectCondition>();
    }
}

