/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations.page;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.management.exportimport.PageExportTask;
import org.exoplatform.portal.mop.management.operations.page.AbstractPageOperationHandler;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.PathTemplateFilter;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.management.api.operation.model.ExportResourceModel;
import org.gatein.mop.api.workspace.Page;

public class PageExportResource
extends AbstractPageOperationHandler {
    @Override
    protected void execute(OperationContext operationContext, ResultHandler resultHandler, Page pages) throws ResourceNotFoundException, OperationException {
        SiteKey siteKey = this.getSiteKey(pages.getSite());
        DataStorage dataStorage = (DataStorage)operationContext.getRuntimeContext().getRuntimeComponent(DataStorage.class);
        PageService pageService = (PageService)operationContext.getRuntimeContext().getRuntimeComponent(PageService.class);
        BindingProvider bindingProvider = operationContext.getBindingProvider();
        Collection pagesList = pages.getChildren();
        ArrayList<PageExportTask> tasks = new ArrayList<PageExportTask>(pagesList.size());
        PageExportTask pageExportTask = new PageExportTask(siteKey, dataStorage, pageService, (Marshaller<Page.PageSet>)bindingProvider.getMarshaller(Page.PageSet.class, ContentType.XML));
        String pageName = operationContext.getAddress().resolvePathTemplate("page-name");
        for (Page page : pagesList) {
            if (pageName == null) {
                PathTemplateFilter filter;
                PathAddress pageAddress = operationContext.getAddress().append(page.getName());
                operationContext.getManagedResource().getSubResource(pageAddress);
                try {
                    filter = PathTemplateFilter.parse((List)operationContext.getAttributes().getValues("filter"));
                }
                catch (ParseException e) {
                    throw new OperationException(operationContext.getOperationName(), "Could not parse filter attributes.", (Throwable)e);
                }
                if (!pageAddress.accepts(filter)) continue;
                pageExportTask.addPageName(page.getName());
                continue;
            }
            if (!pageName.equals(page.getName())) continue;
            pageExportTask.addPageName(page.getName());
        }
        if (pageExportTask.getPageNames().isEmpty() && pageName != null) {
            throw new ResourceNotFoundException("No page found for " + new PageKey(siteKey, pageName));
        }
        if (pageExportTask.getPageNames().isEmpty()) {
            resultHandler.completed((Object)new ExportResourceModel(Collections.emptyList()));
        } else {
            tasks.add(pageExportTask);
            resultHandler.completed((Object)new ExportResourceModel(tasks));
        }
    }
}

