/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.migrate;

import java.util.List;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.GateInTokenStore;
import org.exoplatform.web.security.JCRGateInTokenStorage;
import org.exoplatform.web.security.jpa.JPAGateInTokenStorage;
import org.exoplatform.web.security.security.TokenExistsException;
import org.picocontainer.Startable;

public class TokenDataMigrationService
implements Startable {
    private final String SETTING_KEY_TOKEN_MIGRATED = "GATEIN_TOKEN_MIGRATED";
    private final String SETTING_KEY_TOKEN_CLEANUP = "GATEIN_TOKEN_CLEANUP";
    private final int LIMIT_THRESHOLD = 100;
    protected Log LOG = ExoLogger.getLogger(TokenDataMigrationService.class);
    private final JPAGateInTokenStorage jpaStore;
    private final JCRGateInTokenStorage jcrStore;
    private final SettingService settingService;
    private boolean forkStop;
    private boolean isMigrated;
    private boolean isCleanDone;

    public TokenDataMigrationService(JPAGateInTokenStorage jpaStore, JCRGateInTokenStorage jcrStore, SettingService settingService) {
        this.jpaStore = jpaStore;
        this.jcrStore = jcrStore;
        this.settingService = settingService;
        this.forkStop = false;
        this.isMigrated = false;
        this.isCleanDone = false;
    }

    public void start() {
        this.forkStop = false;
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.beforeMigration();
            if (!this.isMigrated) {
                this.doMigration();
            }
            if (this.isMigrated && !this.isCleanDone) {
                this.doRemove();
            }
            this.afterMigration();
        }
        catch (Exception e) {
            this.LOG.error((Object)"Failed to run migration data from JCR to Mysql.", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
        this.forkStop = true;
    }

    private void beforeMigration() {
        this.isMigrated = this.getSetting("GATEIN_TOKEN_MIGRATED");
        this.isCleanDone = this.getSetting("GATEIN_TOKEN_CLEANUP");
    }

    private void afterMigration() {
        if (!this.forkStop) {
            this.saveSetting("GATEIN_TOKEN_CLEANUP", this.isCleanDone);
            this.saveSetting("GATEIN_TOKEN_MIGRATED", this.isMigrated);
        }
    }

    private boolean getSetting(String key) {
        SettingValue setting = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), "GATEIN_TOKEN_MIGRATED");
        if (setting != null) {
            return Boolean.parseBoolean((String)setting.getValue());
        }
        return false;
    }

    private void saveSetting(String key, boolean value) {
        SettingValue setting = SettingValue.create((String)String.valueOf(value));
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), "GATEIN_TOKEN_MIGRATED", setting);
    }

    private void doMigration() {
        long offset = 0L;
        long limit = 100L;
        boolean next = true;
        boolean success = true;
        while (next) {
            List<GateInTokenStore.TokenData> tokens = this.jcrStore.getAll(offset, limit);
            boolean hasData = tokens != null && !tokens.isEmpty();
            for (GateInTokenStore.TokenData token : tokens) {
                try {
                    this.jpaStore.saveToken(token);
                }
                catch (TokenExistsException tokenExistsException) {
                }
                catch (Exception ex) {
                    this.LOG.error((Object)("There is exception while migrate token data with id: " + token.tokenId), (Throwable)ex);
                    success = false;
                }
            }
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            offset += limit;
            next = hasData && !this.forkStop;
        }
        this.isMigrated = success && !this.forkStop;
    }

    private void doRemove() {
        try {
            this.jcrStore.deleteAll();
            this.isCleanDone = true;
        }
        catch (Exception ex) {
            this.LOG.error((Object)"Error when clean up token", (Throwable)ex);
        }
    }
}

