/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.ProtectedContainer;
import org.exoplatform.portal.mop.ProtectedResource;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.management.operations.page.PageUtils;
import org.exoplatform.portal.mop.page.DataCache;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageData;
import org.exoplatform.portal.mop.page.PageError;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageServiceException;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.page.SimpleDataCache;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.portal.pom.data.MappedAttributes;
import org.gatein.mop.api.Attributes;
import org.gatein.mop.api.content.ContentType;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;
import org.gatein.mop.api.workspace.WorkspaceCustomizationContext;
import org.gatein.mop.api.workspace.ui.UIComponent;
import org.gatein.mop.api.workspace.ui.UIContainer;
import org.gatein.mop.api.workspace.ui.UIWindow;

public class PageServiceImpl
implements PageService {
    final POMSessionManager manager;
    private final DataCache dataCache;

    public PageServiceImpl(POMSessionManager manager) throws NullPointerException {
        this(manager, new SimpleDataCache());
    }

    public PageServiceImpl(POMSessionManager manager, DataCache dataCache) throws NullPointerException {
        if (manager == null) {
            throw new NullPointerException("No null pom session manager allowed");
        }
        if (dataCache == null) {
            throw new NullPointerException("No null data cache allowed");
        }
        this.manager = manager;
        this.dataCache = dataCache;
    }

    public PageContext loadPage(PageKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        POMSession session = this.manager.getSession();
        PageData data = this.dataCache.getPageData(session, key);
        return data != null && data != PageData.EMPTY ? new PageContext(data) : null;
    }

    public List<PageContext> loadPages(SiteKey siteKey) throws NullPointerException, PageServiceException {
        if (siteKey == null) {
            throw new NullPointerException("No null site key accepted");
        }
        POMSession session = this.manager.getSession();
        ObjectType objectType = Utils.objectType((SiteType)siteKey.getType());
        Workspace workspace = session.getWorkspace();
        Site site = workspace.getSite(objectType, siteKey.getName());
        if (site == null) {
            throw new PageServiceException(PageError.NO_SITE);
        }
        Page root = site.getRootPage();
        Collection pages = root.getChild("pages").getChildren();
        ArrayList<PageContext> list = new ArrayList<PageContext>(pages.size());
        for (Page page : pages) {
            list.add(this.loadPage(new PageKey(siteKey, page.getName())));
        }
        return list;
    }

    public boolean savePage(PageContext page) {
        boolean created;
        if (page == null) {
            throw new NullPointerException();
        }
        POMSession session = this.manager.getSession();
        ObjectType objectType = Utils.objectType((SiteType)page.key.getSite().getType());
        Workspace workspace = session.getWorkspace();
        Site site = workspace.getSite(objectType, page.key.getSite().getName());
        if (site == null) {
            throw new PageServiceException(PageError.NO_SITE);
        }
        Page root = site.getRootPage();
        Page pages = root.getChild("pages");
        Page dst = pages.getChild(page.key.getName());
        if (dst == null) {
            dst = pages.addChild(page.key.getName());
            created = true;
        } else {
            created = false;
        }
        PageState state = page.state;
        if (state != null) {
            ProtectedResource pr = (ProtectedResource)dst.adapt(ProtectedResource.class);
            pr.setAccessPermissions(page.state.accessPermissions);
            pr.setEditPermission(page.state.editPermission);
            ProtectedContainer dstPc = (ProtectedContainer)dst.adapt(ProtectedContainer.class);
            dstPc.setMoveAppsPermissions(page.state.moveAppsPermissions);
            dstPc.setMoveContainersPermissions(page.state.moveContainersPermissions);
            Described described = (Described)dst.adapt(Described.class);
            described.setName(page.state.displayName);
            described.setDescription(page.state.description);
            Attributes attrs = dst.getAttributes();
            attrs.setValue(MappedAttributes.FACTORY_ID, (Object)page.state.factoryId);
            attrs.setValue(MappedAttributes.SHOW_MAX_WINDOW, (Object)page.state.showMaxWindow);
        }
        this.dataCache.removePage(session, page.key);
        page.data = this.dataCache.getPageData(session, page.key);
        page.state = null;
        return created;
    }

    public boolean destroyPage(PageKey key) {
        if (key == null) {
            throw new NullPointerException("No null page argument");
        }
        POMSession session = this.manager.getSession();
        ObjectType objectType = Utils.objectType((SiteType)key.getSite().getType());
        Workspace workspace = session.getWorkspace();
        Site site = workspace.getSite(objectType, key.getSite().getName());
        if (site == null) {
            throw new PageServiceException(PageError.NO_SITE);
        }
        Page root = site.getRootPage();
        Page pages = root.getChild("pages");
        Page page = pages.getChild(key.getName());
        if (page != null) {
            page.destroy();
            this.dataCache.removePage(session, key);
            return true;
        }
        return false;
    }

    public PageContext clone(PageKey src, PageKey dst) {
        ObjectType srcType;
        POMSession session = this.manager.getSession();
        Workspace workspace = session.getWorkspace();
        Site srcSite = workspace.getSite(srcType = Utils.objectType((SiteType)src.site.getType()), src.site.getName());
        if (srcSite == null) {
            throw new PageServiceException(PageError.CLONE_NO_SRC_SITE, "Could not clone page " + src.getName() + "from non existing site of type " + src.site.getType() + " with id " + src.site.getName());
        }
        Page root = srcSite.getRootPage();
        Page pages = root.getChild("pages");
        Page srcPage = pages.getChild(src.getName());
        if (srcPage == null) {
            throw new PageServiceException(PageError.CLONE_NO_SRC_PAGE, "Could not clone non existing page " + src.getName() + " from site of type " + src.site.getType() + " with id " + src.site.getName());
        }
        ObjectType dstType = Utils.objectType((SiteType)dst.getSite().getType());
        Site dstSite = workspace.getSite(dstType, dst.getSite().getName());
        if (dstSite == null) {
            throw new PageServiceException(PageError.CLONE_NO_DST_SITE, "Could not clone page " + dst.name + "to non existing site of type " + dst.site.getType() + " with id " + dst.site.getName());
        }
        Page dstRoot = dstSite.getRootPage();
        Page dstPages = dstRoot.getChild("pages");
        if (dstPages.getChild(dst.getName()) != null) {
            throw new PageServiceException(PageError.CLONE_DST_ALREADY_EXIST, "Could not clone page " + dst.name + "to existing page " + dst.site.getType() + " with id " + dst.site.getName());
        }
        Page dstPage = dstPages.addChild(dst.getName());
        Attributes srcAttrs = srcPage.getAttributes();
        Attributes dstAttrs = dstPage.getAttributes();
        for (String key : srcAttrs.getKeys()) {
            Object value = srcAttrs.getObject(key);
            dstAttrs.setObject(key, value);
        }
        Described srcDescribed = (Described)srcPage.adapt(Described.class);
        Described dstDescribed = (Described)dstPage.adapt(Described.class);
        dstDescribed.setName(srcDescribed.getName());
        dstDescribed.setDescription(srcDescribed.getDescription());
        ProtectedResource srcPR = (ProtectedResource)srcPage.adapt(ProtectedResource.class);
        ProtectedResource dstPR = (ProtectedResource)dstPage.adapt(ProtectedResource.class);
        dstPR.setAccessPermissions(srcPR.getAccessPermissions());
        dstPR.setEditPermission(srcPR.getEditPermission());
        if (srcPage.isAdapted(ProtectedContainer.class)) {
            ProtectedContainer srcPc = (ProtectedContainer)srcPage.adapt(ProtectedContainer.class);
            ProtectedContainer dstPc = (ProtectedContainer)dstPage.adapt(ProtectedContainer.class);
            dstPc.setMoveAppsPermissions(srcPc.getMoveAppsPermissions());
            dstPc.setMoveContainersPermissions(srcPc.getMoveContainersPermissions());
        }
        this.copy(srcPage, dstPage, srcPage.getRootComponent(), dstPage.getRootComponent());
        this.dataCache.removePage(session, dst);
        return new PageContext(PageUtils.getPageData(dstPage));
    }

    private void copy(Page srcPage, Page dstPage, UIContainer src, UIContainer dst) {
        for (UIComponent srcChild : src.getComponents()) {
            UIComponent dstChild = dst.add(srcChild.getObjectType(), srcChild.getObjectId());
            if (srcChild.isAdapted(Described.class)) {
                Described srcDescribed = (Described)srcChild.adapt(Described.class);
                Described dstDescribed = (Described)dstChild.adapt(Described.class);
                dstDescribed.setName(srcDescribed.getName());
                dstDescribed.setDescription(srcDescribed.getDescription());
            }
            if (srcChild.isAdapted(ProtectedResource.class)) {
                ProtectedResource srcPR = (ProtectedResource)srcChild.adapt(ProtectedResource.class);
                ProtectedResource dstPR = (ProtectedResource)dstChild.adapt(ProtectedResource.class);
                dstPR.setAccessPermissions(srcPR.getAccessPermissions());
                dstPR.setEditPermission(srcPR.getEditPermission());
            }
            if (srcChild.isAdapted(ProtectedContainer.class)) {
                ProtectedContainer srcPc = (ProtectedContainer)srcPage.adapt(ProtectedContainer.class);
                ProtectedContainer dstPc = (ProtectedContainer)dstPage.adapt(ProtectedContainer.class);
                dstPc.setMoveAppsPermissions(srcPc.getMoveAppsPermissions());
                dstPc.setMoveContainersPermissions(srcPc.getMoveContainersPermissions());
            }
            Attributes srcAttrs = srcChild.getAttributes();
            Attributes dstAttrs = dstChild.getAttributes();
            for (String key : srcAttrs.getKeys()) {
                Object value = srcAttrs.getObject(key);
                dstAttrs.setObject(key, value);
            }
            if (srcChild instanceof UIWindow) {
                UIWindow srcWindow = (UIWindow)srcChild;
                UIWindow dstWindow = (UIWindow)dstChild;
                Customization customization = srcWindow.getCustomization();
                ContentType contentType = customization.getType();
                String contentId = customization.getContentId();
                Customization parent = customization.getParent();
                Customization dstParent = null;
                if (parent != null) {
                    Object state;
                    WorkspaceCustomizationContext parentCtx = (WorkspaceCustomizationContext)parent.getContext();
                    String name = parentCtx.nameOf(parent);
                    if (parentCtx == srcPage && (dstParent = dstPage.getCustomizationContext().getCustomization(name)) == null) {
                        state = parent.getVirtualState();
                        dstParent = dstPage.getCustomizationContext().customize(name, contentType, contentId, state);
                    }
                    if (dstParent != null) {
                        state = customization.getState();
                        Customization dstCustomization = dstWindow.customize(dstParent);
                        dstCustomization.setState(state);
                        continue;
                    }
                    state = customization.getVirtualState();
                    dstWindow.customize(contentType, contentId, state);
                    continue;
                }
                Object state = customization.getVirtualState();
                dstWindow.customize(contentType, contentId, state);
                continue;
            }
            if (!(srcChild instanceof UIContainer)) continue;
            UIContainer srcContainer = (UIContainer)srcChild;
            UIContainer dstContainer = (UIContainer)dstChild;
            this.copy(srcPage, dstPage, srcContainer, dstContainer);
        }
    }

    public QueryResult<PageContext> findPages(int from, int to, SiteType siteType, String siteName, String pageName, String pageTitle) {
        POMSession session = this.manager.getSession();
        org.chromattic.api.query.QueryResult a = session.findObjects(ObjectType.PAGE, (ObjectType<Site>)Utils.objectType((SiteType)siteType), siteName, pageTitle, from, to);
        int size = a.size();
        PageContext[] array = new PageContext[size];
        int ptr = 0;
        while (a.hasNext()) {
            Page page = (Page)a.next();
            PageData data = PageUtils.getPageData(page);
            this.dataCache.putPage(data);
            array[ptr++] = new PageContext(data);
        }
        return new QueryResult(from, size, Arrays.asList(array));
    }

    public void clearCache() {
        this.dataCache.clear();
    }
}

